/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.upgrade.gui;

import java.awt.*;

public class Header extends Canvas
{

    private String headerText;

    public Header()
    {
        this("");
    }

    public Header(String s)
    {
        headerText = null;
        headerText = s;
        setForeground(Color.black);
        try
        {
            setFont(new Font("SansSerif", 0, 12));
        }
        catch(Error _ex) { }
    }

    public Dimension getMinimumSize()
    {
        return getPreferredSize();
    }

    public Dimension getPreferredSize()
    {
        return new Dimension(getSize().width, 22);
    }

    public String getText()
    {
        return headerText;
    }

    public void paint(Graphics g)
    {
        Dimension dimension = getSize();
        g.setClip(0, 0, dimension.width, dimension.height);
        FontMetrics fontmetrics = null;
        g.setColor(getBackground());
        g.fillRect(0, 0, dimension.width + 1, dimension.height + 1);
        g.setColor(getForeground());
        g.setFont(getFont());
        fontmetrics = Toolkit.getDefaultToolkit().getFontMetrics(getFont());
        int i = (dimension.height - (fontmetrics.getMaxAscent() + fontmetrics.getMaxDescent())) / 2 + fontmetrics.getMaxAscent();
        g.drawString(headerText, fontmetrics.stringWidth(""), i);
        int j = dimension.height - fontmetrics.getMaxDescent() / 2;
        g.drawLine(0, j, dimension.width, j);
    }

    public void setText(String s)
    {
        headerText = s;
        repaint();
    }
}
