/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.upgrade.common.arguments;

/**
 *
 * @author Hans Hrasna
 */

import java.util.*;
import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;

public class ParsedArgument {
    
    private Class instructionHandler;
    private String mneumonic;
    private Vector parameters;
    private CommonInfoModel commonInfo;
    private HashMap interactiveMap;
    
    public ParsedArgument(Class instHandler, String cmd, Vector params, CommonInfoModel infoModel, HashMap iMap)  {
        instructionHandler = instHandler;
        mneumonic = cmd;
        parameters = params;
        commonInfo = infoModel;
        interactiveMap = iMap;
    }
    
    public Class getHandler() {
        return instructionHandler;
    }
    
    public String getMneumonic() {
        return mneumonic;
    }
    
    public Vector getParameters() {
        return parameters;
    }
    
    public CommonInfoModel getCommonInfo() {
        return commonInfo;
    }
    
    public HashMap getInteractiveMap() {
        return interactiveMap;
    }
}