/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * CertificateArgumentHandler.java
 *
 * Created on August 25, 2005, 3:24 PM
 */

package com.sun.enterprise.tools.upgrade.common.arguments;

import com.sun.enterprise.tools.upgrade.common.ArgsParser;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import java.util.logging.Level;
import com.sun.enterprise.tools.upgrade.common.UpgradeConstants;

/**
 *
 * @author Hans Hrasna
 */
public abstract class CertificateArgumentHandler extends ArgumentHandler {
    
    /** Creates a new instance of CertificateArgumentHandler */
    public CertificateArgumentHandler(ParsedArgument pa) {
        super(pa);
        commonInfo.setCertificateConversionFlag(true);
    }
    
    /** processCertificatePasswords
     *  Reads password triplets or doublets from passwordFile and sets them in CommonInfoModel
     *  format: domain_name instance_name password
     *      or: domain_name password
     */
    protected void processCertificatePasswords(String pwdfile) {
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(pwdfile)));
            while(reader.ready()){
                String entry = reader.readLine();
                StringTokenizer tokens = new StringTokenizer(entry, " ", false);
                int tokenCount = tokens.countTokens();
                if (tokenCount < 1){
                    _logger.severe(sm.getString("enterprise.tools.upgrade.cli.password_missing",pwdfile));
                    System.exit(1);
                }
                if (tokenCount > 1) {
                    String domainName = tokens.nextToken();                    
                    commonInfo.setCurrentDomain(domainName);
                    commonInfo.addDomainOptionName(domainName);
                }
                if (tokenCount == 3) {
                    commonInfo.setCurrentSourceInstance(tokens.nextToken());
                }
                setCertificatePassword(tokens.nextToken());
                if(commonInfo.getSourceVersion().equals(UpgradeConstants.VERSION_7X)) {
                    interactiveMap.put(ArgsParser.DOMAIN + "-" + commonInfo.getCurrentDomain() + ":" + commonInfo.getCurrentSourceInstance(), pwdfile);
                } else interactiveMap.put(ArgsParser.DOMAIN + "-" + commonInfo.getCurrentDomain(), pwdfile);
            }
        } catch(FileNotFoundException fe) {
            helpUsage();
            _logger.log(Level.SEVERE,sm.getString("enterprise.tools.upgrade.cli.password_file_missing",pwdfile),fe);
            System.exit(1);
        } catch(Exception io) {
            _logger.log(Level.SEVERE,sm.getString("enterprise.tools.upgrade.cli.password_missing",pwdfile),io);
            System.exit(1);
        }
    }
    
    protected abstract void setCertificatePassword(String pwd);
}
