/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.upgrade.common.arguments;

import com.sun.enterprise.tools.upgrade.common.ArgsParser;
import com.sun.enterprise.tools.upgrade.common.PasswordVerifier;

/**
 *
 * @author Hans Hrasna
 */
public class ARG_nsspwdfile extends CertificateArgumentHandler {
    String nssPwdFile;
    
    /** Creates a new instance of ARG_nsspwdfile */
    public ARG_nsspwdfile(ParsedArgument pa) {
        super(pa);
        if (parameters.isEmpty()) {
            helpUsage(sm.getString("enterprise.tools.upgrade.cli.argument_missing, --nsspwdfile/-n"));
            System.exit(1);
        }
        nssPwdFile = (String)parameters.firstElement();
        processCertificatePasswords(nssPwdFile);
    }
    
    protected void setCertificatePassword(String password) {
        if(password == null) {
            _logger.severe(sm.getString("enterprise.tools.upgrade.cli.password_error", nssPwdFile));
            System.exit(1);
        }
        commonInfo.setCertDbPassword(password);
        commonInfo.setNSSPwdFile(nssPwdFile);
        if(!interactiveMap.containsKey("source"))
            return;
        boolean validpwd = PasswordVerifier.verifySourceNSSPassword(commonInfo);
        if(!validpwd) {
            commonInfo.recover();
            _logger.severe(sm.getString("enterprise.tools.upgrade.cli.Invalid_nss_password"));
            System.exit(1);
        }
        interactiveMap.put(ArgsParser.NSSPWD + "-" + commonInfo.getCurrentDomain(), password);       
    }
    
}
