/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


/*
 * ViewLogInterval.java
 */

package com.sun.enterprise.tools.common.util;

import com.sun.enterprise.tools.common.util.diagnostics.Reporter;

public class ViewLogInterval {

	private static int INTERVAL=8000;
	private static int minInterval = 1000;

	public static void setLogInterval(int val){
	   setLogInterval(""+val); // NOI18N
	}

	public static void setLogInterval(String val){
	   Reporter.info(""); //NOI18N
	   if ( (val == null) || val.length() <=0)
		return;
	   try {
		int ret = Integer.parseInt(val);
		if (ret < 0)
		   return;
		INTERVAL = (ret < minInterval)? minInterval : ret;
		Reporter.info("setLogInterval(): " + INTERVAL); //NOI18N
	   }catch (NumberFormatException e){}
        }


	public static int getLogInterval(){
	   return INTERVAL;
	}

}
