/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */

package com.sun.jts.pi;

import org.omg.CORBA.Policy;
import org.omg.CORBA.LocalObject;

import org.omg.CosTransactions.ADAPTS;
import org.omg.CosTransactions.FORBIDS;
import org.omg.CosTransactions.REQUIRES;
import org.omg.CosTransactions.OTSPolicy;
import org.omg.CosTransactions.OTS_POLICY_TYPE;

/**
 * This is the OTSPolicy object which holds an appropriate policy value.
 *
 * @author Ram Jeyaraman 11/11/2000
 * @version 1.0
 */
public class OTSPolicyImpl extends LocalObject implements OTSPolicy {

    // class constants

    public static OTSPolicy _ADAPTS = new OTSPolicyImpl(ADAPTS.value);
    public static OTSPolicy _FORBIDS = new OTSPolicyImpl(FORBIDS.value);
    public static OTSPolicy _REQUIRES = new OTSPolicyImpl(REQUIRES.value);

    // instance variables

    private short value = FORBIDS.value;

    // constructor

    public OTSPolicyImpl() {
        this.value = FORBIDS.value;
    }

    public OTSPolicyImpl(short value) {
        this.value = value;
    }

    // org.omg.CosTransactions.OTSPolicyOperations implementation

    public short value() {
        return this.value;
    }

    // org.omg.CORBA.PolicyOperations implementation

    public int policy_type() {
	return OTS_POLICY_TYPE.value;
    }

    public Policy copy() {
	return new OTSPolicyImpl(this.value);
    }

    public void destroy() {
	value = FORBIDS.value;
    }

    public String toString() {
	return "OTSPolicy[" + this.value + "]";
    }
}
