/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * Copyright 2004-2005 Sun Microsystems, Inc.  All rights reserved.
 * Use is subject to license terms.
 */
//----------------------------------------------------------------------------
//
// Module:      LogControlDescriptor.java
//
// Description: Log control record.
//
// Product:     com.sun.jts.CosTransactions
//
// Author:      Simon Holdsworth
//
// Date:        March, 1997
//
// Copyright (c):   1995-1997 IBM Corp.
//
//   The source code for this program is not published or otherwise divested
//   of its trade secrets, irrespective of what has been deposited with the
//   U.S. Copyright Office.
//
//   This software contains confidential and proprietary information of
//   IBM Corp.
//----------------------------------------------------------------------------

package com.sun.jts.CosTransactions;

// Import required classes

import java.io.*;

/**A class containing control information relating to an open log file.
 *
 * @version 0.01
 *
 * @author Simon Holdsworth, IBM Corporation
 *
 * @see LogHandle
*/
//----------------------------------------------------------------------------
// CHANGE HISTORY
//
// Version By     Change Description
//   0.01  SAJH   Initial implementation.
//------------------------------------------------------------------------------

class LogControlDescriptor implements Serializable {
    /**This constant holds the size of the LogControlDescriptor object.
     */
    final static int SIZEOF = 3*LogLSN.SIZEOF;

    LogLSN headLSN = new LogLSN();
    LogLSN tailLSN = new LogLSN();
    LogLSN nextLSN = new LogLSN();

    /**Default LogControlDescriptor constructor.
     *
     * @param
     *
     * @return
     *
     * @see
     */
    LogControlDescriptor() {
        headLSN = new LogLSN();
        tailLSN = new LogLSN();
        nextLSN = new LogLSN();
    }

    /**Constructs a LogControlDescriptor from the given byte array.
     *
     * @param bytes The array of bytes from which the object is to be constructed.
     * @param index The index in the array where copy is to start.
     *
     * @return
     *
     * @see
     */
    LogControlDescriptor( byte[] bytes,
                          int  index ) {
        headLSN = new LogLSN(bytes,index);  index += LogLSN.SIZEOF;
        tailLSN = new LogLSN(bytes,index);  index += LogLSN.SIZEOF;
        nextLSN = new LogLSN(bytes,index);  index += LogLSN.SIZEOF;
    }

    /**Makes a byte representation of the LogControlDescriptor.
     *
     * @param bytes The array of bytes into which the object is to be copied.
     * @param index The index in the array where copy is to start.
     *
     * @return  Number of bytes copied.
     *
     * @see
     */
    final int toBytes( byte[] bytes,
                       int  index ) {
        index += headLSN.toBytes(bytes,index);
        index += tailLSN.toBytes(bytes,index);
        index += nextLSN.toBytes(bytes,index);

        return SIZEOF;
    }

    /**This method is called to direct the object to format its state into a String.
     *
     * @param
     *
     * @return  The formatted representation of the object.
     *
     * @see
     */
    public final String toString() {
        return "LCD(head="/*#Frozen*/+headLSN+",tail="/*#Frozen*/+tailLSN+",next="/*#Frozen*/+nextLSN+")"/*#Frozen*/;
    }
}
