/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security.jauth.callback;

import javax.security.auth.callback.Callback;
import java.util.Arrays;

/**
 * Callback for PasswordValidation.
 *
 * @version %I%, %G%
 */
public class PasswordValidationCallback implements Callback {

    private String username;
    private char[] password;
    private boolean result = false;

    /**
     * Create a PasswordValidationCallback.
     *
     * @param username the username to authenticate
     *
     * @param password the user's password, which may be null.
     */
    public PasswordValidationCallback(String username, char[] password) {
	this.username = username;
	if (password != null) {
	    this.password = (char[])password.clone();
	}
    }

    /**
     * Get the username.
     *
     * @return the username.
     */
    public String getUsername() {
	return username;
    }

    /**
     * Get the password.
     *
     * <p> Note that this method returns a reference to the password.
     * If a clone of the array is created it is the caller's
     * responsibility to zero out the password information after
     * it is no longer needed.
     *
     * @return the password, which may be null.
     */
    public char[] getPassword() {
	return password;
    }

    /**
     * Clear the password.
     */
    public void clearPassword() {
	if (password != null) {
	    Arrays.fill(password, ' ');
	}
    }

    /**
     * Set the authentication result.
     *
     * @param result true if authentication succeeded, false otherwise
     */
    public void setResult(boolean result) {
	this.result = result;
    }

    /**
     * Get the authentication result.
     *
     * @return true if authentication succeeded, false otherwise
     */
    public boolean getResult() {
	return result;
    }
}
