/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.jdo.spi.persistence.utility;


import com.sun.jdo.spi.persistence.utility.logging.Logger;
import com.sun.jdo.spi.persistence.utility.logging.LogHelper;

/** LogHelper for utility package.
 * @author Dave Bristor
 */
public class LogHelperUtility  {
    /** The component name for this component
     */
    private static final String componentName = "utility"; // NOI18N

    /** The class loader for this component
     */
    private static final ClassLoader loader = 
        LogHelperUtility.class.getClassLoader();

    /** The bundle name for this component
     */
    private static final String bundleName = 
        "com.sun.jdo.spi.persistence.utility.Bundle"; // NOI18N

    /** Return the logger for this component
     */
    public static Logger getLogger() {
        return LogHelper.getLogger(componentName, bundleName, loader);
    }
}
