/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * TableDesc.java
 *
 * Created on March 3, 2000
 *
 */

package com.sun.jdo.spi.persistence.support.sqlstore.model;

import org.netbeans.modules.dbschema.TableElement;
import com.sun.jdo.api.persistence.model.mapping.MappingClassElement;
import java.util.ArrayList;

/**
 * This class is used to represent a database table.
 */
public class TableDesc {

    /** primary key for the table */
    private KeyDesc key;

    /** array of ReferenceKeyDescs referencing secondary tables */
    private ArrayList secondaryTableKeys;

    /** ReferenceKeyDesc referencing the primary table */
    private ReferenceKeyDesc primaryTableKey;

    /** actual TableElement from the dbmodel */
    private TableElement tableElement;

    /** Consistency level for this table defined in the model */
    private int consistencyLevel;

    /** indicates this table is a join table */
    private boolean isJoinTable;

    /** Name of the table */
    private String name;

    /** Version field used for version consistency */
    private LocalFieldDesc versionField;

    public TableDesc(TableElement tableElement) {
        this.tableElement = tableElement;

        name = tableElement.getName().getName();
        consistencyLevel = MappingClassElement.NONE_CONSISTENCY;
    }

    /** Return all secondary table keys.
     *  @return an ArrayList of ReferenceKeyDescs for secondary tables
     */
    public ArrayList getSecondaryTableKeys() {
        return secondaryTableKeys;
    }

    /** Add a new reference key to the list of secondary table keys.
     *  @param key - ReferenceKeyDesc to be added
     */
    void addSecondaryTableKey(ReferenceKeyDesc key) {
        if (secondaryTableKeys == null)
            secondaryTableKeys = new ArrayList();

        secondaryTableKeys.add(key);
    }

    /** Return the reference key referencing the primary table.
     *  @return the ReferenceKeyDesc referencing the primary table
     */
    public ReferenceKeyDesc getPrimaryTableKey() {
        return primaryTableKey;
    }

    /** Set the reference key referencing the primary table.
     *  @param key - ReferenceKeyDesc to be added
     */
    void setPrimaryTableKey(ReferenceKeyDesc key) {
        this.primaryTableKey = key;
    }

    /** Return the primary key for the table.
     *  @return the KeyDesc representing the primary key for the table
     */
    public KeyDesc getKey() {
        return key;
    }

    /** Set the primary key for the table.
     *  @param key - KeyDesc to be set as the primary key
     */
    void setKey(KeyDesc key) {
        this.key = key;
    }

    /** Return the actual dbmodel TableElement for this table.
     *  @return TableElement associated with this table
     */
    public TableElement getTableElement() {
        return tableElement;
    }

    /** Return the name of the table.
     *  @return the name of the table.
     */
    public String getName() {
        return name;
    }

    /** Return true if this table is a join table. */
    public boolean isJoinTable() {
        return isJoinTable;
    }

    /** Set consistencyLevel to value. */
    void setConsistencyLevel(int value) {
        consistencyLevel = value;
        //TODO :
        //if(isUpdateLockRequired() )
            //Check for DBVendorType.isUpdateLockSupported()
            //Log to trace if !DBVendorType.isUpdateLockSupported()
            //If this table is ever used, user would get an exception

    }

    /** Determins if an update lock is required on this table. */
    public boolean isUpdateLockRequired() {
        return consistencyLevel == MappingClassElement.LOCK_WHEN_LOADED_CONSISTENCY;
    }

    /** Set isJoinTable to value */
    void setJoinTable(boolean value) {
        isJoinTable = value;
    }

    void setVersionField(LocalFieldDesc field) {
        versionField = field;
    }

    /**
     * Returns the field representing the version column for this
     * table. The version column is used for verification with version
     * consistency. Each table can have only one version column.
     * 
     * @return Version field.
     */
    public LocalFieldDesc getVersionField() {
        return versionField;
    }

}





