/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.jdo.spi.persistence.support.sqlstore;

/**
 * This interface is used to unit test the StateManager.
 */
public interface TestStateManager
{
	/**
     * This method is used to test if a field identified by fieldName
     * is loaded in memory. It returns true is the field is loaded and
     * false, otehrwise.
	 */
	boolean testIsLoaded(String fieldName);

	/**
     * This method is used to test if a field identified by fieldNumber
     * is loaded in memory. It returns true is the field is loaded and
     * false otehrwise.
	 */
	boolean testIsLoaded(int fieldNumber);

	/**
     * This method is used to determine if an instance is in the autopersistent
	 * state. It returns true if the instance is autopersistence and false otherwise.
	 */
	boolean testIsAutoPersistent();
}

