/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * PersistenceElementProperties.java
 *
 * Created on March 2, 2000, 12:54 PM
 */

package com.sun.jdo.api.persistence.model.jdo;

/** 
 *
 * @author raccah
 * @version %I%
 */
public interface PersistenceElementProperties
{
	/** Name of {@link PersistenceElement#getName name} property.
	 */
	public static final String PROP_NAME = "name";					// NOI18N

	/** Name of {@link PersistenceClassElement#isModified modified}
	 * flag for {@link PersistenceClassElement class elements}.
	 */
	public static final String PROP_MODIFIED = "modified";			// NOI18N

	/** Name of {@link PersistenceClassElement#getObjectIdentityType identity}
	 * property for {@link PersistenceClassElement class elements}.
	 */
	public static final String PROP_IDENTITY = "identity";			// NOI18N

	/** Name of {@link PersistenceClassElement#getKeyClass key class}
	 * property for {@link PersistenceClassElement class elements}.
	 */
	public static final String PROP_KEY_CLASS = "keyClass";			// NOI18N

	/** Name of {@link PersistenceClassElement#getFields fields}
	 * property for {@link PersistenceClassElement class elements}.
	 */
	public static final String PROP_FIELDS = "fields";				// NOI18N

	/** Name of {@link PersistenceClassElement#getConcurrencyGroups concurrency
	 * groups} property for {@link PersistenceClassElement class elements}.
	 */
	public static final String PROP_GROUPS = "groups";				// NOI18N

	/** Name of {@link PersistenceFieldElement#getPersistenceType persistence}
	 * property for {@link PersistenceFieldElement field elements}.
	 */
	public static final String PROP_PERSISTENCE = "persistence";	// NOI18N

	/** Name of {@link PersistenceFieldElement#isReadSensitive read sensitivity}
	 * and {@link PersistenceFieldElement#isWriteSensitive write sensitivity}
	 * property for {@link PersistenceFieldElement field elements}.
	 */
	public static final String PROP_SENSITIVITY = "sensitivity";	// NOI18N

	/** Name of {@link PersistenceFieldElement#isKey key field}
	 * property for {@link PersistenceFieldElement field elements}.
	 */
	public static final String PROP_KEY_FIELD = "keyField";			// NOI18N

	/** Name of {@link RelationshipElement#getUpdateAction update action}
	 * property for {@link RelationshipElement relationship elements}.
	 */
	public static final String PROP_UPDATE_ACTION = "updateAction";	// NOI18N

	/** Name of {@link RelationshipElement#getDeleteAction delete action}
	 * property for {@link RelationshipElement relationship elements}.
	 */
	public static final String PROP_DELETE_ACTION = "deleteAction";	// NOI18N

	/** Name of {@link RelationshipElement#isPrefetch prefetch}
	 * property for {@link RelationshipElement relationship elements}.
	 */
	public static final String PROP_PREFETCH = "prefetch";			// NOI18N

	/** Name of {@link RelationshipElement#getLowerBound lower bound}
	 * and {@link RelationshipElement#getUpperBound upper bound}
	 * property for {@link RelationshipElement relationship elements}.
	 */
	public static final String PROP_CARDINALITY = "cardinality";	// NOI18N

	/** Name of {@link RelationshipElement#getCollectionClass collection class}
	 * property for {@link RelationshipElement relationship elements}.
	 */
	public static final String PROP_COLLECTION_CLASS = 
		"collectionClass";											// NOI18N

	/** Name of {@link RelationshipElement#getElementClass element class}
	 * property for {@link RelationshipElement relationship elements}.
	 */
	public static final String PROP_ELEMENT_CLASS = "elementClass";	// NOI18N

	/** Name of {@link RelationshipElement#getInverseRelationshipName inverse
	 * relationship name} property for {@link RelationshipElement relationship 
	 * elements}.
	 */
	public static final String PROP_INVERSE_FIELD = "relatedField";	// NOI18N
}
