/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.meta;


/**
 * Thrown to indicate that an access to JDO meta-data failed due to a
 * serious error, which might have left the meta-data component in an
 * inconsistent state.
 */
public class JDOMetaDataFatalError
    //^olsen: provisional, convert to a checked exception
    extends RuntimeException
{
    /**
     * An optional nested exception.
     */
    public final Throwable nested;

    /**
     * Constructs an <code>JDOMetaDataFatalError</code> with no detail message.
     */
    public JDOMetaDataFatalError()
    {
        this.nested = null;
    }

    /**
     * Constructs an <code>JDOMetaDataFatalError</code> with the specified
     * detail message.
     */
    public JDOMetaDataFatalError(String msg)
    {
        super(msg);
        this.nested = null;
    }

    /**
     * Constructs an <code>JDOMetaDataFatalError</code> with an optional
     * nested exception.
     */
    public JDOMetaDataFatalError(Throwable nested)
    {
        super(nested.toString());
        this.nested = nested;
    }

    /**
     * Constructs an <code>JDOMetaDataFatalError</code> with the specified
     * detail message and an optional nested exception.
     */
    public JDOMetaDataFatalError(String msg, Throwable nested)
    {
        super(msg);
        this.nested = nested;
    }
}
