/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.*;

/**
 * GenericAttribute represents a class attribute in a class file which
 * is not recognized as any supported attribute type.  These attributes
 * are maintained, and are not modified in any way.
 */

public class GenericAttribute extends ClassAttribute {

  /* The bytes of the attribute following the name */
  byte attributeBytes[];

  /* public accessors */

  /**
   * constructor
   */
  public GenericAttribute(ConstUtf8 attrName, byte attrBytes[]) {
    super(attrName);
    attributeBytes = attrBytes;
  }

  void write(DataOutputStream out) throws IOException {
    out.writeShort(attrName().getIndex());
    out.writeInt(attributeBytes.length);
    out.write(attributeBytes, 0, attributeBytes.length);
  }

  void print(PrintStream out, int indent) {
    ClassPrint.spaces(out, indent);
    out.println("Generic Attribute(" + attrName().asString() + "): " +//NOI18N
               Integer.toString(attributeBytes.length) +
                " in length");//NOI18N
    for (int i=0; i<attributeBytes.length; i++) {
      if ((i % 16) == 0) {
	if (i != 0) 
	  out.println();
	out.print(i + " :");//NOI18N
      }
      out.print(" " + Integer.toString((attributeBytes[i] & 0xff), 16));//NOI18N
    }
    out.println();
  }
}

