/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.jdo.api.persistence.enhancer.classfile;

import java.io.*;
import java.util.Vector;
import java.util.Enumeration;

/**
 * ExceptionTable represents the exception handlers within the code
 * of a method.
 */

public class ExceptionTable {
  /* A variable length list of ExceptionRange objects */
  private Vector theVector = new Vector();

  /* public accessors */

  /**
   * Return an enumeration of the exception handlers
   * Each element in the enumeration is an ExceptionRange
   */
  public Enumeration handlers() {
    return theVector.elements();
  }

  /**
   * Add an exception handler to the list
   */
  public void addElement(ExceptionRange range) {
    theVector.addElement(range);
  }

  public ExceptionTable() { }

  /* package local methods */

  static ExceptionTable read(DataInputStream data, CodeEnv env)
    throws IOException {
    ExceptionTable excTable = new ExceptionTable();
    int nExcepts = data.readUnsignedShort();
    while (nExcepts-- > 0) {
      excTable.addElement(ExceptionRange.read(data, env));
    }
    return excTable;
  }

  void write(DataOutputStream out) throws IOException {
    out.writeShort(theVector.size());
    for (int i=0; i<theVector.size(); i++)
      ((ExceptionRange) theVector.elementAt(i)).write(out);
  }

  void print(PrintStream out, int indent) {
    ClassPrint.spaces(out, indent);
    out.println("Exception Table: ");//NOI18N
    for (int i=0; i<theVector.size(); i++)
      ((ExceptionRange) theVector.elementAt(i)).print(out, indent+2);
  }
}



