/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.webservices;

import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

/* 
 *   @class.setup_props: ; 
 */ 

/*  
 *   @testName: check  
 *   @assertion_ids: JSR109_WS_46; 
 *   @test_Strategy: 
 *   @class.testArgs: Additional arguments (if any) to be passed when execing the client  
 *   @testDescription: SEI must extend the java.rmi.Remote interface.
 */

public class SEIExtendsRemoteCheck  extends WSTest implements WSCheck {

    /**
     * @param descriptor the  WebService deployment descriptor
     * @return <code>Result</code> the results for this assertion
     */
    public Result check (WebServiceEndpoint descriptor) {
        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        // get hold of the SEI Class
        String s = descriptor.getServiceEndpointInterface();
        if (s == null) {
            // internal error, should never happen
            result.failed(smh.getLocalString
                    ("com.sun.enterprise.tools.verifier.tests.webservices.Error",
                            "Error: Unexpected error occurred [ {0} ]",
                            new Object[] {"SEI Class Name Null"}));
            return result;

        }
        Class sei = null;
        try {
            sei = Class.forName(s, false, getVerifierContext().getClassLoader());
        } catch(ClassNotFoundException e) {
            addErrorDetails(result, compName);
            result.failed(smh.getLocalString
                    ("com.sun.enterprise.tools.verifier.tests.webservices.Error",
                            "Error: Unexpected error occurred [ {0} ]",
                            new Object[] {e.toString()}));

            return result;
        }
        if (!(getVerifierContext().getSchemaVersion().compareTo("1.1") > 0)) {
            if(!java.rmi.Remote.class.isAssignableFrom(sei)) {
                result.addErrorDetails(smh.getLocalString ("tests.componentNameConstructor",
                        "For [ {0} ]", new Object[] {compName.toString()}));
                result.failed(smh.getLocalString(getClass().getName() + ".failed",
                        "SEI [{0}] does not extend the java.rmi.Remote interface.",
                        new Object[] {s}));
            }
        } else if (java.rmi.Remote.class.isAssignableFrom(sei)) {
            result.addWarningDetails(smh.getLocalString ("tests.componentNameConstructor",
                    "For [ {0} ]", new Object[] {compName.toString()}));
            result.warning(smh.getLocalString(getClass().getName() + ".warning",
                    "SEI [{0}] is not required to extend the java.rmi.Remote interface.",
                    new Object[] {s}));
        }
        if(result.getStatus() != Result.FAILED
                && result.getStatus() != Result.WARNING) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString(getClass().getName() + ".passed",
                    "Service Enpoint is defined properly"));
        }
        return result;
    }
}

