/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.web.runtime;


import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.tools.verifier.tests.web.*;
import com.sun.enterprise.deployment.runtime.web.*;

//import com.sun.enterprise.tools.common.dd.webapp.*;

//<addition author="irfan@sun.com" [bug/rfe]-id="4711198" >
/* Changed the result messages to reflect consistency between the result messages generated 
 * for the EJB test cases for SunONE specific deployment descriptors*/
//</addition>


public class ASCache extends WebTest implements WebCheck{

    public Result check(WebBundleDescriptor descriptor) {
        
	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
        boolean oneFailed = false;
        boolean notApp = false;
        String maxEntries=null;
        String timeout=null;
        int intMaxEntries;
        long longTimeout;
        String enabled=null;
        
        try{
        Cache cache = (descriptor.getSunDescriptor()).getCache();
    
        if (cache != null)
        {
            maxEntries = cache.getAttributeValue(Cache.MAX_ENTRIES);
            timeout = cache.getAttributeValue(Cache.TIMEOUT_IN_SECONDS);
            enabled = cache.getAttributeValue(Cache.ENABLED);
            if (!(enabled.equalsIgnoreCase("true")) && !(enabled.equalsIgnoreCase("false")))
            {

            addErrorDetails(result, compName);
                result.failed(smh.getLocalString
                    (getClass().getName() + ".failed3",
                    "FAILED [AS-WEB cache] enabled  [ {0} ], attribute must be a proper boolean  value. ",
                    new Object[] {enabled}));
                    oneFailed = true;
            }
            else
            {
            addGoodDetails(result, compName);
                result.passed(smh.getLocalString
                    (getClass().getName() + ".passed3",
                        "PASSED [AS-WEB cache] enabled  [ {0} ] defined properly.",
                         new Object[] {enabled}));
            }     
              

            boolean validMaxEntriesValue=true;
            boolean validTimeOutValue=true;
            try
            {
                if(maxEntries !=null && maxEntries.length() != 0)     // check maxEntries.length() != 0 because is IMPLIED att
                {
                    intMaxEntries=Integer.parseInt(maxEntries);
                    if(intMaxEntries >0 && intMaxEntries < Integer.MAX_VALUE)
                        validMaxEntriesValue=true;
                    else
                        validMaxEntriesValue=false;
                }
            }
            catch(NumberFormatException exception)
            {
                validMaxEntriesValue=false;
                if (!oneFailed)
                    oneFailed = true;
            }
            if(validMaxEntriesValue)
            {
                addGoodDetails(result, compName);
                result.passed(smh.getLocalString
                    (getClass().getName() + ".passed",
                    "PASSED [AS-WEB cache] max-entries [ {0} ] defined properly.",
                    new Object[] {maxEntries}));
            }else
            {
                addErrorDetails(result, compName);
                result.failed(smh.getLocalString
                    (getClass().getName() + ".failed",
                    "FAILED [AS-WEB cache] max-entries [ {0} ], attribute must be a proper integer value. "+
                        "Its range should be 1 to MAX_INT.",
                        new Object[] {maxEntries}));
                     oneFailed = true;
            }
            try
            {
                if(timeout  != null && timeout.length() != 0 ) // check timeout.length() != 0 because is IMPLIED att
                {
                    longTimeout=Long.parseLong(timeout);
                    if(longTimeout >= -1 && longTimeout <= Long.MAX_VALUE)
                        validTimeOutValue=true;
                    else
                        validTimeOutValue=false;
                }                 

            }catch(NumberFormatException exception) 
            {
                validTimeOutValue=false;
                    oneFailed = true;
            }
            if(validTimeOutValue)
            {
                addGoodDetails(result, compName);
                result.passed(smh.getLocalString
                    (getClass().getName() + ".passed1",
                        "PASSED [AS-WEB cache] timeout-in-seconds  [ {0} ] defined properly.",
                         new Object[] {timeout}));
            }
            else
            {
                addErrorDetails(result, compName);
                result.failed(smh.getLocalString
                    (getClass().getName() + ".failed1",
                    "FAILED [AS-WEB cache] timeout-in-seconds value [ {0} ], attribute must be a proper long value. " +
                    "Its range should be between -1 and MAX_LONG.",
                    new Object[] {timeout}));
                    oneFailed = true;
            }
            
        }else
        {
            notApp = true;
            addNaDetails(result, compName);
	    result.notApplicable(smh.getLocalString
                (getClass().getName() + ".notApplicable",
                    "NOT APPLICABLE [AS-WEB cache] Element not defined for the web application.",
                     new Object[] {descriptor.getName()}));
        }
        
        if (oneFailed) {
            result.setStatus(Result.FAILED);
        } else if(notApp) {
            result.setStatus(Result.NOT_APPLICABLE);
        }else {
            result.setStatus(Result.PASSED);
        }
        }catch(Exception ex){
            oneFailed=true;
            addErrorDetails(result, compName);
            result.failed(smh.getLocalString
                    (getClass().getName() + ".failed2",
                    "FAILED [AS-WEB cache] Could not create the cache object"));
        }
	return result;
    }
}
