/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.web;

import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.TagLibDescriptor;
import com.sun.enterprise.tools.verifier.Context;
import com.sun.enterprise.tools.verifier.tests.ComponentNameConstructor;
import com.sun.enterprise.deployment.WebBundleDescriptor;

/**
 *
 */
public class TagLibPublicID extends WebTest implements WebCheck {

    public Result check(WebBundleDescriptor descriptor) {

        Result result = getInitializedResult();
        ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

        String acceptablePubidLiterals[] = {
            "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.1//EN" ,
            "-//Sun Microsystems, Inc.//DTD JSP Tag Library 1.2//EN" };

        String acceptableURLs[] = {"http://java.sun.com/j2ee/dtds/web-jsptaglibrary_1_1.dtd",
                                   "http://java.sun.com/dtd/web-jsptaglibrary_1_2.dtd"};
        Context context = getVerifierContext();
        TagLibDescriptor tlds[] = context.getTagLibDescriptors();

        addGoodDetails(result, compName);
        result.passed(smh.getLocalString
                (getClass().getName() + ".passed",
                        "Test passed successfully"));

        if (tlds != null && tlds.length !=0) {
            boolean oneFailed = false;
            // iterate over all the tag lib descriptors present in war file
            for (int i=0;i<tlds.length;i++) {
                String publicID = tlds[i].getPublicID();
                String systemID = tlds[i].getSystemID();
                if (publicID==null) continue;
                boolean match = false;
                for (int k=0;k<acceptablePubidLiterals.length;k++) {
                    if (publicID.compareTo(acceptablePubidLiterals[k])==0 && systemID.compareTo(acceptableURLs[k])==0) {
                        match=true;
                        addGoodDetails(result, compName);
                        result.passed
                                (smh.getLocalString
                                (getClass().getName() + ".passed1",
                                        "The deployment descriptor [ {0} ] has the proper PubidLiteral: [ {1} ] and sytemID: [ {2} ]",
                                        new Object[] {tlds[i].getUri(), acceptablePubidLiterals[k], acceptableURLs[k]}));
                        break;
                    }
                }

                if (!match) {
                    oneFailed=true;
                    addErrorDetails(result, compName);
                    result.addErrorDetails
                            (smh.getLocalString
                            (getClass().getName() + ".failed",
                                    "The deployment descriptor for [ {0} ] does not have an expected PubidLiteral or SystemID",
                                    new Object[] {tlds[i].getUri()}));

                }
            }
            if(oneFailed)
                result.setStatus(Result.FAILED);
            return result;

        }
        return result;
    }
}
