/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.tests.persistence;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.PersistenceUnitDescriptor;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.VerifierCheck;
import com.sun.enterprise.tools.verifier.tests.VerifierTest;
import com.sun.enterprise.util.io.FileUtils;

import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * jar files specified using <jar-file> element in persistence.xml should be
 * present in the archive.
 *
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class JarNotFound extends VerifierTest implements VerifierCheck {
    public Result check(Descriptor descriptor) {
        Result result = getInitializedResult();
        result.setStatus(Result.PASSED);
        addErrorDetails(result,
                getVerifierContext().getComponentNameConstructor());
        PersistenceUnitDescriptor pu = PersistenceUnitDescriptor.class.cast(
                descriptor);
        File absolutePURootFile = getAbsolutePuRootFile(pu);
        logger.fine("Absolute PU Root: " + absolutePURootFile);
        String absolutePuRoot = absolutePURootFile.getAbsolutePath();
        List<String> jarFileNames = new ArrayList<String>(pu.getJarFiles());
        for (String jarFileName : jarFileNames) {
            // ASSUMPTION:
            // Because of the way deployment changes names of directories etc.
            // it is very difficult to back calculate path names. So,
            // the following code assumes user is specifying valid URIs.

            // in the xml, names always use '/'
            String nativeJarFileName = jarFileName.replace('/',
                    File.separatorChar);
            final File parentFile = new File(absolutePuRoot).getParentFile();
            // only components are exploded, hence first look for original archives.
            File jarFile = new File(parentFile, nativeJarFileName);
            if (!jarFile.exists()) {
                // if the referenced jar is itself a component, then
                // it might have been exploded, hence let's see
                // if that is the case.

                // let's calculate the name component and path component from this URI
                // e.g. if URI is ../../foo_bar/my-ejb.jar,
                // name component is foo_bar/my-ejb.jar and
                // path component is ../../
                // These are my own notions used here.
                String pathComponent = "";
                String nameComponent = jarFileName;
                if(jarFileName.lastIndexOf("../") != -1) {
                    final int separatorIndex = jarFileName.lastIndexOf("../")+3;
                    pathComponent = jarFileName.substring(0,separatorIndex);
                    nameComponent = jarFileName.substring(separatorIndex);
                }
                logger.fine("For jar-file="+ jarFileName+ ", " +
                        "pathComponent=" +pathComponent +
                        ", nameComponent=" + nameComponent);
                jarFile = new File(new File(parentFile, pathComponent),
                        FileUtils.makeFriendlyFileName(nameComponent));
                if (!jarFile.exists()) {
                    result.failed(smh.getLocalString(
                            getClass().getName() + "failed",
                            "[ {0} ] specified in persistence.xml does not exist in the application.",
                            new Object[]{jarFileName}));
                }
            }
        }
        return result;
    }

    private File getAbsolutePuRootFile(
            PersistenceUnitDescriptor persistenceUnitDescriptor) {
        final String applicationLocation =
                getVerifierContext().getAbstractArchive().getArchiveUri();
        File absolutePuRootFile = new File(applicationLocation,
                persistenceUnitDescriptor.getAbsolutePuRoot().replace('/',
                        File.separatorChar));
        if (!absolutePuRootFile.exists()) {
            throw new RuntimeException(
                    absolutePuRootFile.getAbsolutePath() + " does not exist!");
        }
        return absolutePuRootFile;
    }

}
