/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity.ejbpostcreatemethod;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.ClassLoader;
import com.sun.enterprise.tools.verifier.tests.*;
import javax.ejb.EntityBean;
import java.lang.reflect.*;
import com.sun.enterprise.deployment.*;
import java.util.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbUtils;

/**  
 * Entity Bean's ejbPostCreate(...) methods test.
 * Each entity Bean class may define zero or more ejbPostCreate(...) methods. 
 * The number and signatures of a entity Bean's create methods are specific 
 * to each EJB class. The method signatures must follow these rules: 
 * 
 * The method name must be ejbPostCreate. 
 *
 * Compatibility Note: EJB 1.0 allowed the ejbPostCreate method to throw the 
 * java.rmi.RemoteException to indicate a non-application exception. This 
 * practice is deprecated in EJB 1.1---an EJB 1.1 compliant enterprise bean 
 * should throw the javax.ejb.EJBException or another RuntimeException to 
 * indicate non-application exceptions to the Container (see Section 12.2.2). 
 * Note: Treat as a warning to user in this instance.
 */
public class EjbPostCreateMethodException extends EjbTest implements EjbCheck { 


    /**  
     * Entity Bean's ejbPostCreate(...) methods test.
     * Each entity Bean class may define zero or more ejbPostCreate(...) methods. 
     * The number and signatures of a entity Bean's create methods are specific 
     * to each EJB class. The method signatures must follow these rules: 
     * 
     * Compatibility Note: EJB 1.0 allowed the ejbPostCreate method to throw the 
     * java.rmi.RemoteException to indicate a non-application exception. This 
     * practice is deprecated in EJB 1.1---an EJB 1.1 compliant enterprise bean 
     * should throw the javax.ejb.EJBException or another RuntimeException to 
     * indicate non-application exceptions to the Container (see Section 12.2.2). 
     * Note: Treat as a warning to user in this instance.
     *   
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	if (descriptor instanceof EjbEntityDescriptor) {
	    boolean oneFailed = false;
	    int foundWarning = 0;
	    int foundAtLeastOne = 0;
	    try {
		Context context = getVerifierContext();
		ClassLoader jcl = context.getClassLoader();
		Class c = Class.forName(descriptor.getEjbClassName(), false, getVerifierContext().getClassLoader());

		boolean ejbPostCreateFound = false;
		boolean throwsRemoteException = false;
                // start do while loop here....
                do {
		    Method [] methods = c.getDeclaredMethods();
		    for (int i = 0; i < methods.length; i++) {
			// reset flags from last time thru loop
			ejbPostCreateFound = false;
			throwsRemoteException = false;

			// The method name must be ejbPostCreate. 
			if (methods[i].getName().startsWith("ejbPostCreate")) {
			    foundAtLeastOne++;
			    ejbPostCreateFound = true;

			    // Compatibility Note: EJB 1.0 allowed the ejbPostCreate method to throw
			    // the java.rmi.RemoteException to indicate a non-application 
			    // exception. This practice is deprecated in EJB 1.1---an EJB 1.1 
			    // compliant enterprise bean should throw the javax.ejb.EJBException
			    // or another RuntimeException to indicate non-application 
			    // exceptions to the Container (see Section 12.2.2). 
			    // Note: Treat as a warning to user in this instance.
			    Class [] exceptions = methods[i].getExceptionTypes();
			    if (EjbUtils.isValidRemoteException(exceptions)) {
				throwsRemoteException = true;
			    }

			    // now display the appropriate results for this particular 
			    // ejbPostCreate method
			    if (ejbPostCreateFound  && (!throwsRemoteException)) {
				result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
				result.addGoodDetails(smh.getLocalString
						      (getClass().getName() + ".debug1",
						       "For EJB Class [ {0} ] method [ {1} ]",
						       new Object[] {descriptor.getEjbClassName(),methods[i].getName()}));
				result.addGoodDetails(smh.getLocalString
						      (getClass().getName() + ".passed",
						       "[ {0} ] declares [ {1} ] method which properly does not throw java.rmi.RemoteException.",
						       new Object[] {descriptor.getEjbClassName(),methods[i].getName()}));
			    } else if (ejbPostCreateFound  && throwsRemoteException) {
				result.addWarningDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
				result.addWarningDetails(smh.getLocalString
							 (getClass().getName() + ".debug1",
							  "For EJB Class [ {0} ] method [ {1} ]",
							  new Object[] {descriptor.getEjbClassName(),methods[i].getName()}));
				result.addWarningDetails(smh.getLocalString
							 (getClass().getName() + ".warning",
							  "Error: Compatibility Note:" +
							  "\n An [ {0} ] method was found, but" +
							  "\n EJB 1.0 allowed the ejbPostCreate method to throw the " +
							  "\n java.rmi.RemoteException to indicate a non-application" +
							  "\n exception. This practice is deprecated in EJB 1.1" +
							  "\n ---an EJB 1.1 compliant enterprise bean should" +
							  "\n throw the javax.ejb.EJBException or another " +
							  "\n RuntimeException to indicate non-application exceptions" +
							  "\n to the Container. ",
							  new Object[] {methods[i].getName()}));
				foundWarning++;
			    } 
			}
		    }
                } while (((c = c.getSuperclass()) != null) && (foundAtLeastOne == 0));
        
		if (foundAtLeastOne == 0) {
		    result.addNaDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		    result.notApplicable(smh.getLocalString
					 (getClass().getName() + ".notApplicable1",
					  "[ {0} ] does not declare any ejbPostCreate(...) methods.",
					  new Object[] {descriptor.getEjbClassName()}));
		}
	    } catch (ClassNotFoundException e) {
		Verifier.debug(e);
		result.addErrorDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		result.failed(smh.getLocalString
			      (getClass().getName() + ".failedException",
			       "Error: [ {0} ] class not found.",
			       new Object[] {descriptor.getEjbClassName()}));
		oneFailed = true;
	    }  

	    if (oneFailed) {
		result.setStatus(result.FAILED);
            } else if (foundAtLeastOne == 0) {
                result.setStatus(result.NOT_APPLICABLE);
	    } else if (foundWarning > 0) {
		result.setStatus(result.WARNING);
	    } else {
		result.setStatus(result.PASSED);
	    } 

	    return result;
 
	} else {
	    result.addNaDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "[ {0} ] expected {1} bean, but called with {2} bean.",
				  new Object[] {getClass(),"Entity","Session"}));
	    return result;
	}
    }
}
