/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2;

import com.sun.enterprise.deployment.*;
import com.sun.enterprise.deployment.RelationRoleDescriptor;
import com.sun.enterprise.deployment.CMRFieldInfo;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.tools.verifier.tests.*;

/**
 * Container-managed fields declaration test.
 * CMR fields accessor methods names must the field name with the first
 * letter uppercased and prefixed with get and set
 * 
 * @author  Jerome Dochez
 * @author Sheetal Vartak
 * @version 
 */
public class CmrFieldAccessor extends CmrFieldTest {

    /**
     * run an individual verifier test of a declated cmr field of the class
     *
     * @param entity the descriptor for the entity bean containing the cmp-field    
     * @param rrd the descriptor for the declared cmr field
     * @param c the class owning the cmp field
     * @param result the result object to use to put the test results in
     * 
     * @return true if the test passed
     */            
    protected boolean runIndividualCmrTest(Descriptor entity, RelationRoleDescriptor rrd, Class c, Result result) {
	boolean oneFailed = false;
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
	    CMRFieldInfo info = rrd.getCMRFieldInfo();
	    if (info == null) {
		 addErrorDetails(result, compName);
		result.addErrorDetails(smh.getLocalString
		            ("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.isAccessorDeclared.failed1",
                            "Error : no CMR Field  declared ",
		            new Object[] {}));  
		return false;
	    }
	    oneFailed = isAccessorDeclared(info.name, info.type, c, result);
	    if (oneFailed == false) {
            // do nothing, appropriate message has been added in
            // isAccessorDeclared().
	    }else {
		 result.addGoodDetails(smh.getLocalString
				       ("tests.componentNameConstructor",
					"For [ {0} ]",
					new Object[] {compName.toString()}));
		result.addGoodDetails(smh.getLocalString
		            ("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.isAccessorDeclared.passed",
                            "CMR Field is properly declared ",
		            new Object[] {}));     
	    }
	    return oneFailed;
    }
}
