/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.Field;
import java.util.*;
import java.util.logging.Level;

import com.sun.enterprise.deployment.Descriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbEntityDescriptor;
import com.sun.enterprise.deployment.EjbCMPEntityDescriptor;
import com.sun.enterprise.tools.verifier.*;
import java.lang.ClassLoader;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;

/** 
 * Container-managed fields test.
 * If the enterprise bean is a Entity Bean  w/Container managed persistence
 * the Bean provider must specify container managed fields in the 
 * "persistent-fields" element.
 */
public class PersistenceFieldsElement extends EjbTest implements EjbCheck { 

    /**
     * Container-managed fields test.
     * If the enterprise bean is a Entity Bean  w/Container managed persistence
     * the Bean provider must specify container managed fields in the
     * "persistent-fields" element.
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	if (descriptor instanceof EjbEntityDescriptor) {
	    String persistentType = 
		((EjbEntityDescriptor)descriptor).getPersistenceType();
	    if (EjbEntityDescriptor.CONTAINER_PERSISTENCE.equals(persistentType)) {

                // this test apply only to 1.x cmp beans, in 2.x fields are virtual fields only
                if (EjbCMPEntityDescriptor.CMP_1_1!=((EjbCMPEntityDescriptor) descriptor).getCMPVersion()) {
		    result.addNaDetails(smh.getLocalString
					("tests.componentNameConstructor",
					 "For [ {0} ]",
					 new Object[] {compName.toString()}));
	            result.notApplicable(smh.getLocalString
				 ("com.sun.enterprise.tools.verifier.tests.ejb.entity.cmp2.CMPTest.notApplicable3",
				  "Test do not apply to this cmp-version of container managed persistence EJBs"));
        	    return result;
                }
            logger.log(Level.FINE, getClass().getName() + ".debug1",
                    new Object[] {persistentType});
		// RULE: Entity w/Container managed persistence bean provider must
		//       specify container managed fields in the persistent-fields
		//       element
		Set persistentFields =
		    ((EjbCMPEntityDescriptor)descriptor).getPersistenceDescriptor().getCMPFields();
		Iterator iterator = persistentFields.iterator();

		// check class to see if fields actually exist
		try {
		    Context context = getVerifierContext();
		    ClassLoader jcl = context.getClassLoader();
		    Class c = Class.forName(descriptor.getEjbClassName(), false, getVerifierContext().getClassLoader());

		    Descriptor persistentField;
		    Field field;
		    boolean oneFailed = false;
		    while (iterator.hasNext()) {
			persistentField = (Descriptor)iterator.next();
			try {
			    field = c.getField(persistentField.getName());
			    result.addGoodDetails(smh.getLocalString
						  ("tests.componentNameConstructor",
						   "For [ {0} ]",
						   new Object[] {compName.toString()}));
			    result.passed(smh.getLocalString
					  (getClass().getName() + ".passed",
					   "[ {0} ] field found in [ {1} ]",
					   new Object[] {((Descriptor)persistentField).getName(),descriptor.getEjbClassName()}));
			} catch (NoSuchFieldException e) {
			    result.addErrorDetails(smh.getLocalString
						   ("tests.componentNameConstructor",
						    "For [ {0} ]",
						    new Object[] {compName.toString()}));
			    result.failed(smh.getLocalString
					  (getClass().getName() + ".failedException1",
					   "Error: NoSuchFieldException: [ {0} ] not found in [ {1} ]",
					   new Object[] {((Descriptor)persistentField).getName(),descriptor.getEjbClassName()}));
			    if (!oneFailed) {
				oneFailed = true;
			    }

			} catch (SecurityException e) {
			    result.addErrorDetails(smh.getLocalString
						   ("tests.componentNameConstructor",
						    "For [ {0} ]",
						    new Object[] {compName.toString()}));
			    result.failed(smh.getLocalString
					  (getClass().getName() + ".failedException2",
					   "Error: SecurityException: [ {0} ] not found in [ {1} ]",
					   new Object[] {((Descriptor)persistentField).getName(),descriptor.getEjbClassName()}));
			    if (!oneFailed) {
				oneFailed = true;
			    }
			}
		    }
		    if (oneFailed) {
			result.setStatus(Result.FAILED);
		    } else {
			result.setStatus(Result.PASSED);
		    }
		} catch (ClassNotFoundException e) {
		    Verifier.debug(e);
		    result.addErrorDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));
		    result.failed(smh.getLocalString
				  (getClass().getName() + ".failedException3",
				   "Error: Fields don't exist or are not loadable within bean [ {0} ]",
				   new Object[] {descriptor.getName()}));
		}
	    } else if (EjbEntityDescriptor.BEAN_PERSISTENCE.equals(persistentType))
		{
		    result.addNaDetails(smh.getLocalString
					("tests.componentNameConstructor",
					 "For [ {0} ]",
					 new Object[] {compName.toString()}));
		    result.notApplicable(smh.getLocalString
					 (getClass().getName() + ".notApplicable1",
					  "Expected persistence type [ {0} ], but [ {1} ] bean has persistence type [ {2} ]",
					  new Object[] {EjbEntityDescriptor.CONTAINER_PERSISTENCE,descriptor.getName(),persistentType}));
		} else {
		    result.addErrorDetails(smh.getLocalString
					   ("tests.componentNameConstructor",
					    "For [ {0} ]",
					    new Object[] {compName.toString()}));
		    result.failed(smh.getLocalString
				  (getClass().getName() + ".failed",
				   "Error: [ {0} ] is not valid persistentType within bean [ {1} ]",
				   new Object[] {persistentType, descriptor.getName()}));
		} 
	    return result;
	} else {
	    result.addNaDetails(smh.getLocalString
				("tests.componentNameConstructor",
				 "For [ {0} ]",
				 new Object[] {compName.toString()}));
	    result.notApplicable(smh.getLocalString
				 (getClass().getName() + ".notApplicable",
				  "[ {0} ] expected {1} bean, but called with {2} bean.",
				  new Object[] {getClass(),"Entity","Session"}));
	    return result;
	} 
    }
}
