/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.entity;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.ClassLoader;
import com.sun.enterprise.tools.verifier.tests.*;
import java.lang.reflect.Field;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;

/** 
 * Any CMP entity bean should have at least one cmp field defined in the DDs
 */
public class CMPFieldExistence extends EjbTest implements EjbCheck { 


    /** 
     * Any CMP entity bean should have at least one cmp field defined in the DDs
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
        if (descriptor instanceof EjbEntityDescriptor) {
	    String persistentType = 
		((EjbEntityDescriptor)descriptor).getPersistenceType();
	    if (EjbEntityDescriptor.CONTAINER_PERSISTENCE.equals(persistentType)) {
                EjbCMPEntityDescriptor cmpDesc = (EjbCMPEntityDescriptor) descriptor;
                PersistenceDescriptor persDesc = cmpDesc.getPersistenceDescriptor();
                if (persDesc.getCMPFields().size()==0) {
                    result.failed(smh.getLocalString
                                           (getClass().getName()+"failed",
                                            "For CMP entity bean [ {0} ], no cmp field are defined",
                                            new Object[] {descriptor.getName()}));
                } else {
                    result.passed(smh.getLocalString
                                           (getClass().getName() + ".passed",
                                            "For CMP entity bean [ {0} ], some cmp fields are defined",
                                            new Object[] {descriptor.getName()}));                    
                }
                return result;
            } 
        }
        
        // everything else is NA
        result.notApplicable(smh.getLocalString
				(getClass().getName() + ".notApplicable",
				 "The EJB [ {0} ] is not an CMP entity bean",
				 new Object[] {descriptor.getName()}));    
         return result;
    }
}
