/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb.businessmethod;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.lang.reflect.*;
import java.util.Set;

import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.ejb.EjbCheck;
import com.sun.enterprise.tools.verifier.tests.ejb.RmiIIOPUtils;
import com.sun.enterprise.tools.verifier.tests.*;


/**  
 * Enterprise Bean's business(...) methods argument RMI IIOP test.
 * Each enterprise Bean class must define zero or more business(...) methods. 
 * The method signatures must follow these rules: 
 * 
 * The methods return value must be legal types for RMI-IIOP. 
 */
public class BusinessMethodRmiIIOPReturn extends EjbTest implements EjbCheck { 
    
    Result result = null;
    ComponentNameConstructor compName = null;
    /** 
     * Enterprise Bean's business(...) methods argument RMI IIOP test.
     * Each enterprise Bean class must define zero or more business(...)  
     * methods.  The method signatures must follow these rules: 
     * 
     * The methods return value must be legal types for RMI-IIOP. 
     * 
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *   
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {
        
        result = getInitializedResult();
        compName = getVerifierContext().getComponentNameConstructor();
        
        if ((descriptor instanceof EjbSessionDescriptor)  ||
                (descriptor instanceof EjbEntityDescriptor)) {
            if(descriptor.getRemoteClassName() != null && !"".equals(descriptor.getRemoteClassName())) 
                commonToBothInterfaces(descriptor.getRemoteClassName(),descriptor);
            
            Set<String> remoteInterfaces = descriptor.getRemoteBusinessClassNames();
            for (String remoteIntf : remoteInterfaces) 
                commonToBothInterfaces(remoteIntf, descriptor);
        } 
        if(result.getStatus() != Result.FAILED) {
            addGoodDetails(result, compName);
            result.passed(smh.getLocalString
                    (getClass().getName() + ".passed",
                    "Proper declaration of business method(s) found."));
        }
        return result;
    }
    
    private void commonToBothInterfaces(String intf, EjbDescriptor descriptor) {
        try {
            Class intfClass = Class.forName(intf, false, getVerifierContext().getClassLoader());
            
            for (Method remoteMethod : intfClass.getMethods()) {
                
                // we don't test the EJB methods
                if (remoteMethod.getDeclaringClass().getName().equals("javax.ejb.EJBObject")) 
                    continue;
                Class beanClass = Class.forName(descriptor.getEjbClassName(), 
                                                false, 
                                                getVerifierContext().getClassLoader());
                for (Method method : beanClass.getMethods()) {
                    
                    if (method.getName().equals(remoteMethod.getName()) &&
                            !RmiIIOPUtils.isValidRmiIIOPReturnType(method.getReturnType())) {
                        // The methods arguments types must be legal types for
                        // RMI-IIOP.  This means that their return values must
                        // be of valid types for RMI-IIOP,
                        addErrorDetails(result, compName);
                        result.failed(smh.getLocalString
                                (getClass().getName() + ".failed",
                                "Error: business method [ {0} ] was found, but " +
                                "business method has invalid return type [ {1} ]. Business " +
                                "method return type must be a valid type for RMI-IIOP.",
                                new Object[] {method.getName(), method.getReturnType()}));
                    }
                }
            }
            
        } catch (ClassNotFoundException e) {
            Verifier.debug(e);
            addErrorDetails(result, compName);
            result.failed(smh.getLocalString
                    (getClass().getName() + ".failedException",
                    "Error: Remote interface [ {0} ] or bean class [ {1} ] does " +
                    "not exist or is not loadable within bean [ {2} ].",
                    new Object[] {descriptor.getRemoteClassName(),
                                  descriptor.getEjbClassName(),
                                  descriptor.getName()}));
        }  
        
    }
}
