/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

/**
 * If the Application assembler defines security roles in the deployment 
 * descriptor, the Application Assembler must bind security role references 
 * declared by the Bean Provider to the security roles. 
 */
public class SecurityRolesBind extends EjbTest implements EjbCheck { 



    /** 
     * If the Application assembler defines security roles in the deployment
     * descriptor, the Application Assembler must bind security role references
     * declared by the Bean Provider to the security roles.
     *
     * @param descriptor the Enterprise Java Bean deployment descriptor
     *
     * @return <code>Result</code> the results for this assertion
     */
    public Result check(EjbDescriptor descriptor) {

	Result result = getInitializedResult();
	ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();

	EjbBundleDescriptor bundleDescriptor = descriptor.getEjbBundleDescriptor();
	Set ejbs = bundleDescriptor.getEjbs();
	Iterator ejbIterator = ejbs.iterator();
	EjbDescriptor ejb = null;
	Set roleReferences = null;
	Iterator roleRefsIterator = null;
	Set roles = bundleDescriptor.getRoles();
	Iterator rolesIterator = roles.iterator();
	RoleReference roleReference = null;
	Role role = null;
	boolean oneFailed = false;
        
	// check to see if there are any undefined roles being referenced
	while (ejbIterator.hasNext()) {
	    ejb = (EjbDescriptor)ejbIterator.next();
	    roleReferences = ejb.getRoleReferences();
	    roleRefsIterator = roleReferences.iterator();
	    if (roleRefsIterator.hasNext()) {
		while (roleRefsIterator.hasNext()) {
		    roleReference = (RoleReference)roleRefsIterator.next();
		    role = roleReference.getRole();
		    if (!role.getName().equals("")
			&& !bundleDescriptor.getRoles().contains(role) ) {
			// print the undefine role
			result.addErrorDetails(smh.getLocalString
					       ("tests.componentNameConstructor",
						"For [ {0} ]",
						new Object[] {compName.toString()}));
			result.addErrorDetails(smh.getLocalString
					       (getClass().getName() + ".failed",
						"Error: The role [ {0} ] for bean [ {1} ] is undefined.",
						new Object[] {role.getName(),ejb.getName()}));
			if (!oneFailed) {
			    oneFailed = true;
			}
		    } else {
			result.addGoodDetails(smh.getLocalString
					      ("tests.componentNameConstructor",
					       "For [ {0} ]",
					       new Object[] {compName.toString()}));
			result.passed(smh.getLocalString
				      (getClass().getName() + ".passed",
				       "The role [ {0} ] for bean [ {1} ] is defined.",
				       new Object[] {role.getName(),ejb.getName()}));
		    }
		}
	    } else {
		result.addNaDetails(smh.getLocalString
				    ("tests.componentNameConstructor",
				     "For [ {0} ]",
				     new Object[] {compName.toString()}));
		result.notApplicable(smh.getLocalString
				     (getClass().getName() + ".notApplicable",
				      "There are no role references which need to be bound to other security roles within this bean [ {0} ]",
				      new Object[] {ejb.getName()}));
	    }
	}

	if (oneFailed) {
	    result.setStatus(Result.FAILED);   
	}
        
	return result;
    }    
}
