/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import com.sun.enterprise.tools.verifier.tests.ejb.EjbTest;
import java.util.*;
import com.sun.enterprise.deployment.*;
import com.sun.enterprise.tools.verifier.*;
import com.sun.enterprise.tools.verifier.tests.*;

/** 
 * Security role references test.
 * The Bean provider must declare all of the enterprise's bean references 
 * to security roles as specified in section 15.2.1.3 of the Moscone spec.
 * Role names must be mapped to names within the jar.
 */
public class SecurityIdentityRefs extends EjbTest { 


  /** 
   * Security role references test.
   * The Bean provider must declare all of the enterprise's bean references
   * to security roles as specified in section 15.2.1.3 of the Moscone spec.
   * Role names must be mapped to names within the jar.
   *
   * @param descriptor the Enterprise Java Bean deployment descriptor
   *
   * @return <code>Result</code> the results for this assertion
   */
  public Result check(EjbDescriptor descriptor) {

    Result result = getInitializedResult();
    ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
if (descriptor.getUsesCallerIdentity()){
        result.addNaDetails(smh.getLocalString
            ("tests.componentNameConstructor",
             "For [ {0} ]",
             new Object[] {compName.toString()}));
        result.notApplicable(smh.getLocalString(
              "com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.notApplicable3",
              "Bean [ {0} ] does not specify a run-as identity",
              new Object[] {descriptor.getName()}));
        return result;
    }
    RunAsIdentityDescriptor identity = descriptor.getRunAsIdentity();
    if (identity == null) {
      result.addNaDetails(smh.getLocalString
          ("tests.componentNameConstructor",
           "For [ {0} ]",
           new Object[] {compName.toString()}));
      result.notApplicable(smh.getLocalString(
            "com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.notApplicable2",
            "Bean [ {0} ] does not specify a security identity",
            new Object[] {descriptor.getName()}));                    
      return result;
    }

    EjbBundleDescriptor bundleDescriptor = descriptor.getEjbBundleDescriptor();
    Set roles = bundleDescriptor.getRoles();
    Iterator roleIterator = roles.iterator();
    while (roleIterator.hasNext()) {
      Role role = (Role) roleIterator.next();
      if (role.getName().equals(identity.getRoleName())) {
        result.addGoodDetails(smh.getLocalString
            ("tests.componentNameConstructor",
             "For [ {0} ]",
             new Object[] {compName.toString()}));
        result.passed(smh.getLocalString(
              "com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.passed",
              "Security identity run-as specified identity [ {0} ] role is found in the list of roles",
              new Object[] {role.getName()}));        
        return result;                
      }
    }
    result.addErrorDetails(smh.getLocalString
        ("tests.componentNameConstructor",
         "For [ {0} ]",
         new Object[] {compName.toString()}));
    result.failed(smh.getLocalString(
          "com.sun.enterprise.tools.verifier.tests.ejb.SecurityIdentityRefs.failed",
          "Security identity run-as specified identity [ {0} ] role is not valid",
          new Object[] {identity.getRoleName()}));        
    return result;                
  }

}
