/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.tools.verifier.tests.ejb;

import java.util.*;
import java.lang.reflect.*;

/** 
 * Utility package for dealing with method descriptors from <method-permission>
 * element and <container-transaction> elements
 */
public class MethodUtils { 

    /** 
     * Add method name to vector
     *
     * @param v Vector to be added to
     * @param methods array of methods to be added to vector 
     *   
     */
    public static void addMethodNamesToVector(Vector<String> v, Method[] methods) {
        for (int i=0; i< methods.length; i++) {
            // add method name to vector
            v.addElement(methods[i].getName());
        }
    }
 
    /** 
     * Determine is method parameters are equal.
     *
     * @param v Vector to be added to
     * @param hMethods array of home interface methods to be added to vector 
     * @param rMethods array of remote interface methods to be added to vector 
     *   
     */
    public static void addMethodNamesToVector(Vector<String> v, Method[] hMethods, Method[] rMethods) {
        // add method names to vector for both home and remote interfaces
        addMethodNamesToVector(v,hMethods);
        addMethodNamesToVector(v,rMethods);
    }
 
   
    /** 
     * Determine is method parameters are equal.
     *
     * @param s1 array of parameters for method 
     * @param s2 array of parameters for method 
     *   
     * @return <code>boolean</code> the results for this parameter equality test
     */
    public static boolean stringArrayEquals(String[] s1, String[] s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null && s2 != null) {
            return false;
        }
        if (s2 == null && s1 != null) {
            return false;
        }
        if (s1.length == s2.length) {
            for (int i = 0; i < s1.length; i++) {
                if (!s1[i].equals(s2[i])) {
                    return false;
                }
            }
            return true;
        } else {
            return false;
        }
    }
    
    /** returns true if method names, return types and parameters match. Otherwise
     * it returns false. */
    public static boolean methodEquals(Method classMethod, Method intfMethod) {
        return classMethod.getName().equals(intfMethod.getName()) &&
                intfMethod.getReturnType().isAssignableFrom(classMethod.getReturnType()) &&
                Arrays.equals(classMethod.getParameterTypes(), intfMethod.getParameterTypes());
    }

}
