/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
/*
 * ConnectionFactoryExistence.java
 *
 * Created on September 28, 2000, 4:59 PM
 */

package com.sun.enterprise.tools.verifier.tests.connector.cci;

import com.sun.enterprise.tools.verifier.tests.connector.ConnectorTest;
import com.sun.enterprise.tools.verifier.tests.connector.ConnectorCheck;
import com.sun.enterprise.tools.verifier.Result;
import com.sun.enterprise.deployment.ConnectorDescriptor;
import com.sun.enterprise.tools.verifier.tests.*;
import com.sun.enterprise.tools.verifier.tests.*;


/**
 * Verify that the interface declared in the deployment descriptor 
 * connectionfactory-interface is actually contained in the archive
 *
 * @author  Jerome Dochez
 * @version 
 */
public class ConnectionFactoryInterfaceExistence extends ConnectionFactoryTest implements ConnectorCheck
{


    /**
     * <p>
     * Verify that the interface declared in the deployment descriptor 
     * connectionfactory-interface is actually contained in the archive
     * </p>
     *
     * @paramm descriptor deployment descriptor for the rar file
     * @return result object containing the result of the individual test
     * performed
     */
    public Result check(ConnectorDescriptor descriptor) {
        
      Result result = getInitializedResult();
      ComponentNameConstructor compName = getVerifierContext().getComponentNameConstructor();
      if(isCCIImplemented(descriptor, result))
      {
        /*String interfaceName = descriptor.getConnectionFactoryInterface();
        if (interfaceName == null) {
          result.addErrorDetails(smh.getLocalString
              ("tests.componentNameConstructor",
               "For [ {0} ]",
               new Object[] {compName.toString()}));
          result.failed(smh.getLocalString
              (getClass().getName() + ".nonexist",
               "Error: The deployment descriptor for the resource adapter do not define a connectionfactory-interface"));        
        }*/        
        isClassLoadable("javax.resource.cci.ConnectionFactory", result); 
      }
      else
      {
        result.addNaDetails(smh.getLocalString
            ("tests.componentNameConstructor",
             "For [ {0} ]",
             new Object[] {compName.toString()}));
        result.notApplicable(smh.getLocalString
            ("com.sun.enterprise.tools.verifier.tests.connector.cci.notApp",
             "The CCI interfaces do not seem to be implemented by this resource adapter"));
      }
      return result;
    }
}
