/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.apiscan.classfile;

import java.util.Collection;

/**
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public interface Method {
    /**
     * @return the {@link ClassFile} this method belongs to.
     */
    ClassFile getOwningClass();

    /**
     * @return the name of the method.
     */
    String getName();

    /**
     * @return return the descriptor, e.g. ([Ljava.lang.String;)V
     */
    String getDescriptor();

    /**
     * @return return the access flags.
     */
    int getAccess();

    /**
     * Used only when method's parameters or return type use generics.
     * @return
     */
    String getSignature();

    /**
     * @return the internal names of the method's exception classes. May be null.
     */
    String[] getExceptions();

    /**
     *
     * @return an unmodifiable collection of method references representing
     * the methods that are invoked directly (i.e. not recurssively) from this
     * method.
     */
    Collection<MethodRef> getReferencedMethods();

    /**
     *
     * @return an unmodifiable collection of class names in external format
     * representing the classes that are directly (i.e. not recurssively)
     * referenced by this method.
     */
    Collection<String> getReferencedClasses();

    /**
     * @return a reference that represents this method.
     */
    MethodRef getSelfReference();

    /**
     *
     * @return true if this is a native method else false
     */
    boolean isNative();

}
