/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */


package com.sun.enterprise.tools.verifier.apiscan.classfile;

import java.util.Collection;
import java.util.logging.Logger;
import java.lang.ref.SoftReference;

/**
 * @author Sanjeeb.Sahoo@Sun.COM
 */
public class BCELMethod implements Method{

    private SoftReference<ClassFile> owningClass;

    private com.sun.org.apache.bcel.internal.classfile.Method method;

    private static Logger logger = Logger.getLogger("apiscan.classfile"); // NOI18N

    public BCELMethod(ClassFile owningClass,
                      com.sun.org.apache.bcel.internal.classfile.Method method) {
        logger.entering("BCELMethod", "BCELMethod", // NOI18N
                new Object[]{owningClass.getName(), method.getName()});
        this.owningClass = new SoftReference<ClassFile>(owningClass);
        this.method = method;
    }

    public ClassFile getOwningClass() {
        return owningClass.get();
    }

    public String getName() {
        return method.getName();
    }

    public String getDescriptor() {
        return method.getSignature();
    }

    public int getAccess() {
        return method.getAccessFlags();
    }

    public String getSignature() {
        throw new UnsupportedOperationException();
    }

    public String[] getExceptions() {
        throw new UnsupportedOperationException();
    }

    public Collection<MethodRef> getReferencedMethods() {
        throw new UnsupportedOperationException();
    }

    public Collection<String> getReferencedClasses() {
        throw new UnsupportedOperationException();
    }

    public MethodRef getSelfReference() {
        throw new UnsupportedOperationException();
    }

    public boolean isNative() {
        return method.isNative();
    }
}
