/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.ara;

/**
 * Implement the logic required to execute a set of <code>Rule</code> on 
 * a <code>E</code>.
 *
 * @author JeanFrancois Arcand
 */
public interface RulesExecutor<E> {
    
    /**
     * Execute a set of <code>Rule</code>.
     * @param E the onject on which the <code>Rule</code> will be applied.
     * @return true if the execution was successful.
     */
    public boolean execute(E o);

    /**
     * Is caching of <code>Rule</code> results allowed
     */
    public boolean isCachingAllowed();
}
