/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web.reconfig;

import com.sun.enterprise.admin.event.AdminEventListener;
import com.sun.enterprise.admin.event.AdminEventListenerException;
import com.sun.enterprise.admin.event.http.HSHttpListenerEvent;
import com.sun.enterprise.admin.event.http.HSHttpListenerEventListener;
import org.apache.catalina.LifecycleException;
import com.sun.enterprise.config.ConfigAdd;
import com.sun.enterprise.config.ConfigChange;
import com.sun.enterprise.config.ConfigContext;
import com.sun.enterprise.config.ConfigException;
import com.sun.enterprise.config.ConfigUpdate;
import com.sun.enterprise.config.ConfigBean;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.ElementProperty;
import com.sun.enterprise.config.serverbeans.HttpListener;
import com.sun.enterprise.config.serverbeans.ServerBeansFactory;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.web.PEWebContainer;

import java.util.ArrayList;

/**
 * This class handles dynamic reconfiguration notification related to 
 * http-listener creation, update and deletion.
 *
 * @author Jean-Francois Arcand
 */ 
public class HttpListenerReconfig implements HSHttpListenerEventListener{
    
    private static PEWebContainer webContainer = 
                                 ((PEWebContainer)PEWebContainer.getInstance());
    
    /**
     * Create a new http-listener.
     */
    public void handleCreate(HSHttpListenerEvent event)
                                            throws AdminEventListenerException {
        
        if ( webContainer == null) return;       
        
        try{             
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            
            if ( config == null) return;
            
            ConfigAdd configAdd = null;
            ArrayList configChangeList = event.getConfigChangeList();
            HttpListener httpBean = null;
            String xpath = null;
            Object object;
            Object configObject;
            
            for (int i=0; i < configChangeList.size(); i++){
                configObject = configChangeList.get(i);

                if ( configObject instanceof ConfigAdd) {
                    configAdd = (ConfigAdd)configObject;
                    xpath = configAdd.getXPath();
                    // We are only interested on config change for VirtualServer.
                    if( xpath != null){
                        object = configContext.exactLookup(xpath);
                        if ( object instanceof HttpListener){
                            httpBean = (HttpListener)object;
                            webContainer.createConnector(httpBean, 
                                                         config.getHttpService());
                        }
                    }
                }
            }
        } catch (Exception ex) {
           throw new AdminEventListenerException(ex);
        }  
    }
    
    
    /**
     * Update an existing http-listener.
     */
    public void handleUpdate(HSHttpListenerEvent event)
                                            throws AdminEventListenerException {   
        
        if ( webContainer == null) return;       
                                     
        try{                        
            ConfigContext configContext = event.getConfigContext();
            Config config = ServerBeansFactory.getConfigBean(configContext);
            
            if ( config == null) return;
            
            ConfigChange configChange = null;
            ArrayList<ConfigChange> configChangeList =
                                                    event.getConfigChangeList();
            HttpListener httpBean = null;
            String xpath = null;
            Object object;
            ElementProperty elementProperty = null;
             
            for (int i=0; i < configChangeList.size(); i++){
                configChange = configChangeList.get(i);

                xpath = configChange.getXPath();
                if( xpath != null){
                    object = configContext.exactLookup(xpath);
                    if ( object instanceof HttpListener){
                        httpBean = (HttpListener)object;
                        webContainer.updateConnector(httpBean, 
                                                     config.getHttpService());
                    } else if ( object instanceof ElementProperty) {
                        // This is a property.
                        xpath = xpath.substring(0,xpath.lastIndexOf("/"));
                        httpBean = (HttpListener)configContext.exactLookup(xpath);                       
                        elementProperty = (ElementProperty)object;
                        webContainer.updateConnectorProperty(
                           httpBean, 
                           elementProperty.getName(),
                           elementProperty.getValue());                        
                    }
                }
            }
        } catch (Exception ex) {
           throw new AdminEventListenerException(ex);
        }
    }
    
    
    /**
     * Delete an existing http-listener. 
     *
     * Implementation note: we cannot use the same approach used when
     * handling create/update event since the element is deleted before this
     * method is invoked (strange behaviour). Instead we need to find by 
     * ourself which http-listener has been deleted.
     */
    public void handleDelete(HSHttpListenerEvent event) 
                                            throws AdminEventListenerException {
         
        if ( webContainer == null) return;       
        
        try{
            if( event != null){
                ConfigContext configContext = event.getConfigContext();
                Config config = ServerBeansFactory.getConfigBean(configContext);
                
                if ( config == null) return;
                
                webContainer.deleteConnector(config.getHttpService());    
            }
        }  catch( Exception ex){
           throw new AdminEventListenerException(ex);
        }      
    }     
}
