/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * WebContainerAdminEventProcessor.java
 *
 * Created on September 26, 2003, 4:31 PM
 */

package com.sun.enterprise.web;

import com.sun.enterprise.admin.event.ApplicationDeployEvent;
import com.sun.enterprise.admin.event.ModuleDeployEvent;


/**
 *
 * @author  lwhite
 */
public interface WebContainerAdminEventProcessor {
    
    public void init(EmbeddedWebContainer embedded);    
    
    public void applicationDeployed(ApplicationDeployEvent deployEvent);
    public void applicationRedeployed(ApplicationDeployEvent deployEvent);
    public void applicationUndeployed(ApplicationDeployEvent deployEvent);
    public void applicationDisabled(ApplicationDeployEvent deployEvent);
    public void applicationEnabled(ApplicationDeployEvent deployEvent);
    
    public void moduleDeployed(ModuleDeployEvent deployEvent);
    public void moduleRedeployed(ModuleDeployEvent deployEvent);
    public void moduleUndeployed(ModuleDeployEvent deployEvent);
    public void moduleDisabled(ModuleDeployEvent deployEvent);
    public void moduleEnabled(ModuleDeployEvent deployEvent);    
    
}
