/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.web;

import java.util.Map;
import com.sun.enterprise.webservice.EjbWebServiceServlet;

/**
 * Implementation of AdHocServletInfo interface providing information 
 * specific to the ad-hoc servlet responsible for servicing HTTP requests
 * for EJB webservice endpoints.
 *
 * @author Jan Luehe
 */
public class EjbWebServiceServletInfo implements AdHocServletInfo {

    public static final String EJB_SERVLET_NAME = "EjbWebServiceServlet";

    /**
     * Returns the class type of the servlet that should be created to process
     * requests.  Note that the class must represent a subclass of HttpServlet.
     *
     * @return The servlet class
     */
    public Class getServletClass() {
        return EjbWebServiceServlet.class;
    }
    
    /**
     * Returns the name of the servlet that the container should assign when it
     * adds a servlet to a web module.
     *
     * @return The servlet name
     */
    public String getServletName() {
        return EJB_SERVLET_NAME;
    }
    
    /**
     * Returns a Map containing name and value pairs to be used in preparing
     * the init params in the servlet's ServletConfig object.
     *
     * @return Map containing the servlet init parameters
     */
    public Map getServletInitParams() {
        return null;
    }

}
