/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

//Source File Name:   SybaseXAResource.java

package com.sun.enterprise.transaction;

import javax.transaction.xa.*;
import javax.resource.ResourceException;

import com.sun.enterprise.util.i18n.StringManager;

/**
 * XA Resource wrapper class for sybase XA Resource with jConnect 5.2.
 *
 * @author <a href="mailto:bala.dutt@sun.com">Bala Dutt</a>
 * @version 1.0
 */
public class SybaseXAResource extends XAResourceWrapper
{


	// Sting Manager for Localization
    private static StringManager sm = StringManager.getManager(SybaseXAResource.class);
  /**
   * Returns xids list for recovery depending on flags. Sybase XA Resource ignores the flags
   * for XAResource recover call. This method takes care for the fault. Allows the recover call
   * only for TMSTARTRSCAN, for other values of flags just returns null.
   *
   * @param flag an <code>int</code> value
   * @return a <code>Xid[]</code> value
   * @exception XAException if an error occurs
   */
  public Xid[] recover(int flag) throws XAException {
        try{
            if(flag==XAResource.TMSTARTRSCAN)
                return m_xacon.getXAResource().recover(flag);
        }catch(ResourceException e){
            //a bad xa connection given...
            // throw new XAException("sybase XA resource wrapper : Could not connect : sqlexception was "+e);
            throw new XAException(sm.getString("transaction.sybase_xa_wrapper_connection_failed",e));
        }
        return null;
    }
    public void commit(Xid xid, boolean flag) throws XAException{
        try{
            m_xacon.getXAResource().commit(xid, flag);
        }catch(ResourceException e){
            //a bad xa connection given...
            throw new XAException(sm.getString("transaction.sybase_xa_wrapper_connection_failed",e));
            // throw new XAException("sybase XA resource wrapper :Could not connect : sqlexception was "+e);
        }
    }
    public void rollback(Xid xid) throws XAException{
        try{
            m_xacon.getXAResource().rollback(xid);
        }catch(ResourceException e){
            //a bad xa connection given...
            throw new XAException(sm.getString("transaction.sybase_xa_wrapper_connection_failed",e));
            // throw new XAException("sybase XA resource wrapper :Could not connect : sqlexception was "+e);
        }
    }
}
