/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server.ss.spi;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

/*
 * An interface class for all ASSocketService related operations. 
 */
public interface ASSocketServiceFacade {
    public void clientSocketConnected(Socket s);
    public boolean isServerStartingUp(int port);
    public boolean close(int port, ServerSocket sock, 
                               ServerSocketChannel channel) throws IOException;
    public void waitOnAccept(Socket s);
    public boolean isLocalClient(Socket s);
    public boolean exists(int port);
    public void removeListeningSelector(int port);
    public void waitOnAccept(SocketChannel sc);
    public ServerSocketChannel getServerSocketChannel(int port);
    public ServerSocket getServerSocket(int port);
    public boolean socketServiceNotified(int port);
    public void waitOnClientConnection(Socket s);
}
