/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.server.pluggable;

import java.security.KeyStore;
import com.sun.enterprise.config.ConfigContext;

/**
 * SecuritySupport is part of PluggableFeature that provides access to
 * internal services managed by application server.
 * @author Shing Wai Chan
 */
public interface SecuritySupport {

    /**
     * This method returns an array of keystores containing keys and
     * certificates.
     */
    public KeyStore[] getKeyStores();

    /**
     * This method returns an array of truststores containing certificates.
     */
    public KeyStore[] getTrustStores();

    /**
     * This method returns an array of passwords in order corresponding to
     * array of keystores.
     */
    public String[] getKeyStorePasswords();

    /**
     * @param  token 
     * @return a keystore. If token is null, return the the first keystore.
     */
    public KeyStore getKeyStore(String token);

    /**
     * @param  token 
     * @return a truststore. If token is null, return the first truststore.
     */
    public KeyStore getTrustStore(String token);

    /**
     * @param  token 
     * @return the password for this token. 
     */
    public String getKeyStorePassword(String token);
    
    /**
     * This method returns an array of token names in order corresponding to
     * array of keystores.
     */
    public String[] getTokenNames();

    /**
     * This method synchronize key file for given realm.
     * @param config the ConfigContextx
     * @param fileRealmName
     * @exception if fail to synchronize, a known exception is
     *            com.sun.enterprise.ee.synchronization.SynchronizationException
     */
    public void synchronizeKeyFile(ConfigContext config, String fileRealmName)
        throws Exception;
}
