/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.server;

import com.sun.enterprise.config.serverbeans.*;
import com.sun.enterprise.config.*;
import com.sun.enterprise.config.ConfigException;
import com.sun.logging.LogDomains;
import com.sun.enterprise.admin.event.ResourceDeployEvent;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
  *
  * @author    Srikanth P
  * @version
 */

public abstract class ResourcesLoader {
    static Logger _logger = LogDomains.getLogger(LogDomains.CORE_LOGGER);

    private ServerContext serverContext_;

    private ResourceDeployerFactory factory_ = null;
    protected ResourcesUtil resourceUtil = null;


    public ResourcesLoader(ServerContext sc) throws ConfigException {
        serverContext_ = sc;
        factory_ = new ResourceDeployerFactory();
        resourceUtil = ResourcesUtil.getInstance(sc);
    }

    public void load() {
 
    }

    public void load(ConfigBean[][] configbeanArray) {

        if(configbeanArray == null) {
            return;
        }
        for(int j = 0; j<configbeanArray.length; ++j) {
            if(configbeanArray[j] == null || configbeanArray[j].length == 0) {
                continue;
            }
            ConfigBean[] configBeanSet = configbeanArray[j];
            String resourceType = resourceUtil.getResourceType(
                         configBeanSet[0]);
            if(resourceType == null) {
                _logger.log(Level.SEVERE,"core.no_resource_type" );
                continue;
            }
            ResourceDeployer deployer = null;
            try {
                deployer = factory_.getResourceDeployer(resourceType);
            } catch(Exception ex) {
                _logger.log(Level.SEVERE,
                          "core.no_resource_deployer",resourceType );
                _logger.log(Level.SEVERE,"",ex);
                continue;
            }
            for (int i=0; i<configBeanSet.length; i++) {

                try {
                    if(resourceUtil.isEnabled(configBeanSet[i])) {
                        deployer.deployResource(configBeanSet[i]);
                    }
                } catch(Exception ex) {
                    _logger.log(Level.SEVERE,"core.resource_loading_error");
                    _logger.log(Level.SEVERE,"",ex);
                }
            }
        }
    }

}
