/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

/*
 * SecurityManagerFactory.java
 *
 * Created on June 9, 2003, 11:59 AM
 */

package com.sun.enterprise.security.factory;

import com.sun.enterprise.SecurityManager;
import com.sun.enterprise.deployment.Descriptor;
/**
 * Factory For SecurityManager objects, can return a Web/EJB SecurityManager 
 * Factory
 * @author  Harpreet Singh 
 */
public interface SecurityManagerFactory {    
    /* 
     * Returns the SecurityManager instance corresponding to the factory that
     * is being operated.
     * @param String contextId the context id of the application
     * @return SecurityManager - return the SecurityManager instance
     */
    public SecurityManager getSecurityManager(String contextId);

    /*
     * create a SM instance corresponding to the web/ejb factory being operated
     * on
     * @param Descriptor, if descriptor is of type EjbDescriptor for ejbs
     * and WebBundleDescriptor for web.
     */
    public SecurityManager createSecurityManager(Descriptor descriptor);
    
    /**
     * Remove the SM instance corresponding to this context
     * @param String the contextId of the module
     */
    public void removeSecurityManager(String contextId);
    
}
