/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.security;

import java.security.AccessController;
import java.security.PrivilegedAction;

import com.sun.enterprise.security.auth.login.ClientPasswordLoginModule;
import com.sun.enterprise.security.auth.LoginContextDriver;
import com.sun.enterprise.appclient.AppContainer;
import com.sun.enterprise.util.LocalStringManagerImpl;
import java.util.logging.*;
import com.sun.logging.*;

/** 
 * This class is kept for CTS. Ideally we should move away from it.
 * The login can be done via the following call:
 * <pre>
 * // Initialize the ORB.
 * try {
 *   LoginContext lc = new LoginContext();
 *   lc.login("john", "john123");
 * } catch (LoginException le) {
 *   le.printStackTrace();
 * }
 *
 *
 * </PRE>
 *
 * Ideally the login should be done with the system property -Dj2eelogin.name and -Dj2eelogin.password
 *
 * @author Harpreet Singh (hsingh@eng.sun.com)
 */

public final class LoginContext {
    private static Logger _logger=null;
    static{
       _logger = LogDomains.getLogger(LogDomains.SECURITY_LOGGER);
   }

    private boolean guiAuth = false;

    // declaring this different from the Appcontainer as 
    // this will be called from standalone clients.
    public javax.security.auth.callback.CallbackHandler handler = null;
    
    /**
     * Creates the LoginContext with the defauly callback handler
     */
    public LoginContext () {
	handler = new com.sun.enterprise.security.auth.login.LoginCallbackHandler(guiAuth);
    }
    
    /** 
     * Login method to login username and password
     */
    public void login(String user, String pass) throws LoginException{
	final String username = user;
	final String password = pass;
	AccessController.doPrivileged(new PrivilegedAction() {
	    public java.lang.Object run() {
		
		System.setProperty(ClientPasswordLoginModule.LOGIN_NAME,
				   username);
		System.setProperty(ClientPasswordLoginModule.LOGIN_PASSWORD, 
				   password);

		    return null;
		}
	    });
	// Since this is  a private api and the user is not supposed to use
	// this. We use the default the LoginCallbackHandler.
	LoginContextDriver.doClientLogin(AppContainer.USERNAME_PASSWORD,
					 handler);
    }
    
    /** This method has been provided to satisfy the CTS Porting Package 
     * requirement for logging in a certificate
     */
    public void login(String username, byte[] authData) 
	throws LoginException{
    
	    // do nothing
    }

}



