/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.security;

/**
 * This is an remote interface provided to the RealmManager
 * This allows the realms to be updated while the server is
 * running.
 * @author Harpreet Singh (harpreet.singh@sun.com)
 */
public interface IRealmManager extends java.rmi.Remote{

    /** 
     * This refreshes the realm information. This is used by 
     * a client program e.g. realmtool. The client manipulates
     * the realm information and then calls this method. This then
     * updates the realm information in an already running server.
     * If the server is not running the call should not be made. 
     * This interface is obtained by looking up the <i>RealmManager</> 
     * from the Naming service.
     * @param String realmName
     */
    public void refreshRealms(String realmName) 
	throws java.rmi.RemoteException;
}
