/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.resource.monitor;

import javax.management.j2ee.statistics.RangeStatistic;
import javax.management.j2ee.statistics.Statistic;

import com.sun.enterprise.admin.monitor.stats.GenericStatsImpl;
import com.sun.enterprise.admin.monitor.stats.RangeStatisticImpl;

/**
 * 
 * @author Sivakumar Thyagarajan
 */
public class AbstractStatsImpl {
    //@todo : initialized by sub-classes 
    protected GenericStatsImpl gsImpl;

    /** 
     * This is an implementation of the mandatory JSR77 Stats
     * interface method.
     * Here we simply delegate it to the GenericStatsImpl object
     * that we have
     */
    public Statistic[] getStatistics() {
        return gsImpl.getStatistics();
    }

    /** 
     * This is an implementation of the mandatory JSR77 Stats
     * interface method.
     * Here we simply delegate it to the GenericStatsImpl object
     * that we have
     */
    public Statistic getStatistic( String str ) {
        return gsImpl.getStatistic( str );
    }

     /** 
     * This is an implementation of the mandatory JSR77 Stats
     * interface method.
     * Here we simply delegate it to the GenericStatsImpl object
     * that we have
     */
   public String[] getStatisticNames() {
        return gsImpl.getStatisticNames();
    }

   /**
    * A utility method to update a range statistic
    */
   protected RangeStatistic getUpdatedRangeStatistic 
                       (RangeStatistic originalStat, long currentValue, 
                                       long maxValue, long minValue){
       return new RangeStatisticImpl(currentValue, maxValue, minValue, 
           originalStat.getName(), originalStat.getUnit(), 
           originalStat.getDescription(), originalStat.getStartTime(),
           System.currentTimeMillis());
   }
}
