/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.resource;

import java.security.Principal;
import javax.resource.spi.ConnectionRequestInfo;
import com.sun.enterprise.deployment.ResourcePrincipal;

/**
 * This class represents the client-specific information associated
 * with a resource. Used for pool partitioning
 * 
 * @author Tony Ng
 */
public class ClientSecurityInfo {

    // union: either store Principal or ConnectionRequestInfo
    private ResourcePrincipal prin;
    private ConnectionRequestInfo info;

    static private final int NULL_HASH_CODE = new Integer(1).hashCode();

    public ClientSecurityInfo(ResourcePrincipal prin) {
        if (prin == null) {
            throw new NullPointerException("Principal is null");
        }
        this.prin = prin;
        this.info = null;
    }

    public ClientSecurityInfo(ConnectionRequestInfo info) {
        // info can be null
        this.prin = null;
        this.info = info;
    }


    public ResourcePrincipal getPrincipal() {
        return prin;
    }

    public ConnectionRequestInfo getConnectionRequestInfo() {
        return info;
    }

    public boolean equals(Object obj) {
        if (this == obj) return true;
        if (obj == null) return false;
        if (obj instanceof ClientSecurityInfo) {
            ClientSecurityInfo other = (ClientSecurityInfo) obj;
            return ((isEqual(prin, other.prin)) &&
                    (isEqual(info, other.info)));
        }
        return false;
    }

    public int hashCode() {
        int result = NULL_HASH_CODE;
        if (prin != null) {
            result = prin.hashCode();
        }
        if (info != null) {
            result += info.hashCode();
        }
        return result;
    }

    private boolean isEqual(Object a, Object b) {
        if (a == null) {
            return (b == null);
        } else {
            return (a.equals(b));
        }
    }

    public String toString() {
	return "ClientSecurityInfo: prin=" + prin + " info="+info;
    }
}
