/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.repository;

import java.io.Serializable;

public class ResourcePropertyImpl implements ResourceProperty, 
    Serializable {
    
    private String name_;
    private Object value_;

    public ResourcePropertyImpl(String name) {
        name_  = name;
        value_ = null;
    }

    public ResourcePropertyImpl(String name, Object value) {
        name_  = name;
        value_ = value;
    }

    public String getName() {
        return name_;
    }
    
    public Object getValue() {
        return value_;
    }

    public void setValue(Object value) {
        value_ = value;
    }

    public int hashCode() {
        return name_.hashCode();
    }

    public boolean equals(Object other) {
        boolean equal = false;
        if( other instanceof ResourceProperty ) {
            ResourceProperty otherProp = (ResourceProperty) other;
            equal = this.name_.equals(otherProp.getName());
        }
        return equal;
    }
    
    public String toString() {
        return "ResourceProperty : < " + getName() + " , " + getValue() +
            " >";
    }

}
