/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.management.selfmanagement;

import com.sun.enterprise.admin.selfmanagement.event.Event;

/**
 * Denotes the configured rule in the server instance. It abstracts all the
 * Rule relevent information in it.
 *
 * @author Pankaj Jairath
 */
class Rule {    
    /** One of the states of the rule */
    final static int ENABLED = 0;
    
    final static int INACTIVE = 1;
    
    final static int DISABLED = 2;
    
    final static int NOACTION = 3;
    
    private String name = null;
    
    private String description = null;
    
    private int state = -1;
    
    private Event event = null;
    
    private Object actionMBean = null;

    private boolean isEnabled = false;
    
    /** Creates a new instance of Rule */
    Rule(String ruleName, String ruleDescription) {
        name = ruleName;
        ruleDescription = ruleDescription;
    }

    /** Sets the name of the configured Rule */
    void setName(String ruleName) {
        name = ruleName;
    }
 
    
    /** Retrieves name of the configured rule */
    String getName() {
        return name;
    }
    
    /** Retrieves the description of the configured rule */
    String getDescription() {
        return description;
    }
    
    /** Sets the current state of the configured Rule */
    void setState(int ruleState) {
        state = ruleState;
    }       
    
    /** Retrieves the current state of the configured Rule */
    int getState() {
        return state;
    }
    
    /** Associates the event with the Rule */
    void setEvent(Event ruleEvent) {
        event = ruleEvent;
    }
    
    /** Retrieves the Event associated with the Rule */
    Event getEvent() {
        return event;
    }
    
    /** Associates the Action with the configured Rule */
    void setAction(Object actionInstance) {
        actionMBean = actionInstance;
    }
    
    /** Retrieves the Action associated with the Rule */
    Object getAction() {
        return actionMBean;
    }

    /** Set the enabled status */
    void setEnabled(boolean status) {
        isEnabled = status;
    }

    /** Provides the enabled status of the rule */
    boolean isEnabled() {
        return isEnabled;
    }
}
