/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
/*
 * @(#)SecurityContext.java	1.5 00/10/24
 */

package com.sun.enterprise.iiop.security;

import java.security.cert.*;
import javax.security.auth.*;

/*
 * This interface is part of the contract between CSIV2 interceptors
 * and the rest of J2EE RI.
 *
 * @author  Sekhar Vajjhala
 * @author  Vivek  Nagar
 */


/**
 *  A subject is used a container for passing the security context
 *  information in the service context field. The security context
 *  information in the subject must be stored either as a private or
 *  a public credential according to the following convention:
 *
 *    PasswordCredential:
 *      Client authentication will be performed using the username
 *      and password in the PasswordCredential. PasswordCredential
 *      must be passed as a PrivateCredential.
 *
 *    X500Name:
 *      DN name specified in X500Name will be asserted. X500Name must 
 *      be passed as a PublicCredential.
 *
 *    GSSUPName:
 *      Identity specified in GSSUPName will be asserted. GSSUPName must
 *      be passed as a PublicCredential.
 *
 *    X509CertificateCredential:
 *      The certificate chain in the credential will be asserted. The 
 *      credential must be passed as a PublicCredential.
 *
 *    AnonCredential:
 *      Anonymous identity will be asserted. Credential must be passed
 *      as a PublicCredential.
 *
 *    Class fields in the SecurityContext are used for credential selection.
 *    There are two class fields: authcls and identcls.
 *    
 *    authcls is a Class object that identifies the credential for 
 *    client authentication.
 *          
 *    identcls is a Class object that identifies the credential for
 *    identity assertion.
 *
 *  The following semantics must be observed:
 * 
 *  1. A client authentication token is always passed as a private
 *     credential. authcls set to the class of the authentication token
 *     
 *  2. An identity token is always passed as a public credential.
 *     identcls is set to the class of the identity token.
 *  
 *  3. authcls is set to null if there is no client auth token
 * 
 *  4. identcls is set to null if there is no ident token
 *
 *  5. There must not be more than one instance of class identified
 *     by authcls or identcls. However, there can be one instance of
 *     identcls *and* authcls (this allows both a client auth token
 *     and an identity token to be passed across the interface).
 */

public class SecurityContext {
    public Subject subject;
    public Class   authcls;
    public Class   identcls;
}

