/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

package com.sun.enterprise.iiop.security;

import java.io.*;
import java.net.Socket;

import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.transport.SocketInfo;
import com.sun.corba.ee.org.omg.CSI.*;
import com.sun.corba.ee.org.omg.CSIIOP.*;


/** 
 * @author Vivek Nagar
 */

public final class ConnectionContext implements Serializable {
    private CompoundSecMech mechanism = null;
    private boolean sslClientAuth = false;
    private boolean ssl = false;
    private IOR ior = null;
    private Socket socket = null;
    private SocketInfo endpoint = null;

    /**
     * Default constructor.
     */
    public ConnectionContext() {
    }

    /**
     * Create the security mechanism context. This is stored in TLS.
     */
    public ConnectionContext(CompoundSecMech mech, IOR ior) {
	this.ior = ior;
	mechanism = mech;
    }

    /**
     * Return the IOR.
     */
     public IOR getIOR() {
	return ior;
     }

    /**
     * Set the IOR
     */
    public void setIOR(IOR ior) {
	this.ior = ior;
    }

    /**
     * Return the selected compound security mechanism.
     */
    public CompoundSecMech getMechanism() {
	return mechanism;
    }

    /**
     * Set the mechanism used for this invocation.
     */
    public void setMechanism(CompoundSecMech mech) {
	mechanism = mech;
    }

    /**
     * Return true if SSL client authentication has happened, false otherwise.
     */
    public boolean getSSLClientAuthenticationOccurred() {
	return sslClientAuth;
    }

    /**
     * Set true if SSL client authentication has happened.
     */
    public void setSSLClientAuthenticationOccurred(boolean val) {
	sslClientAuth = val;
    }

    /**
     * Return true if SSL was used to invoke the EJB.
     */
    public boolean getSSLUsed() {
	return ssl;
    }

    /**
     * Set true if SSL was used to invoke the EJB.
     */
    public void setSSLUsed(boolean val) {
	ssl = val;
    }

    public void setEndPointInfo(SocketInfo info) {
	endpoint = info;
    }

    public SocketInfo getEndPointInfo() {
	return endpoint;
    }

    /**
     * Return the socket for this connection.
     */
    public Socket getSocket() {
	return socket;
    }

    /**
     * Set the socket for this connection.
     */
    public void setSocket(Socket s) {
	socket = s;
    }

    public String toString() {
	String s = "sslClientAuth=" + sslClientAuth;
	s = s + " SSL=" + ssl;
	s = s + " ENDPOINT=" + endpoint;
	s = s + " mechanism=" + mechanism;
	s = s + " IOR=" + ior;
	s = s + " Socket=" + socket;
	return s;
    }
}


