/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */

//
// Created       : 2005 Jul 29 (Fri) 08:23:33 by Harold Carr.
// Last Modified : 2005 Aug 31 (Wed) 19:57:12 by Harold Carr.
//

package com.sun.enterprise.iiop;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.IORInfo;

import com.sun.corba.ee.spi.folb.ClusterInstanceInfo;
import com.sun.corba.ee.spi.folb.CSIv2SSLTaggedComponentHandler;
import com.sun.corba.ee.spi.ior.IOR;
import com.sun.corba.ee.spi.orb.DataCollector;
import com.sun.corba.ee.spi.orb.ORB;
import com.sun.corba.ee.spi.orb.ORBConfigurator;
import com.sun.corba.ee.spi.transport.SocketInfo;

import com.sun.corba.ee.impl.orbutil.ORBConstants;
import com.sun.corba.ee.impl.orbutil.ORBUtility;

// BEGIN imports for (extract) getSocketInfo code
import com.sun.corba.ee.spi.ior.iiop.IIOPProfileTemplate ;
import com.sun.corba.ee.spi.ior.iiop.IIOPAddress ;
import com.sun.enterprise.iiop.security.SecurityMechanismSelector;
import com.sun.enterprise.iiop.security.ConnectionContext;
// END imports for getSocketInfo code

import com.sun.logging.LogDomains;
//

/**
 * @author Harold Carr
 */
public class CSIv2SSLTaggedComponentHandlerImpl
    extends org.omg.CORBA.LocalObject
    implements CSIv2SSLTaggedComponentHandler,
	       ORBConfigurator
{
    private static Logger _logger = null;
    static {
        _logger = LogDomains.getLogger(LogDomains.CORBA_LOGGER);
    }

    private final String baseMsg = 
	CSIv2SSLTaggedComponentHandlerImpl.class.getName();

    private ORB orb;

    ////////////////////////////////////////////////////
    //
    // CSIv2SSLTaggedComponentHandler
    //

    public TaggedComponent insert(IORInfo iorInfo, 
 				  List<ClusterInstanceInfo> clusterInstanceInfo)
    {
	TaggedComponent result = null;
	try {
	    if (_logger.isLoggable(Level.FINE)) {
		_logger.log(Level.FINE, baseMsg + ".insert->:");
	    }
            List<com.sun.corba.ee.spi.folb.SocketInfo> socketInfos = new ArrayList<com.sun.corba.ee.spi.folb.SocketInfo>();
            for(ClusterInstanceInfo clInstInfo : clusterInstanceInfo){
                for(int endPIndex=0; endPIndex < clInstInfo.endpoints.length; endPIndex++){
                    com.sun.corba.ee.spi.folb.SocketInfo socketInfo = clInstInfo.endpoints[endPIndex];
                    if(socketInfo.type.equals("SSL") || socketInfo.type.equals("SSL_MUTUALAUTH")){
                        socketInfos.add(socketInfo);                  
                    }
                }                
            }
            org.omg.CORBA.ORB orb = com.sun.enterprise.util.ORBManager.getORB();
            int sslMutualAuthPort = -1;
            try {
                sslMutualAuthPort = ((com.sun.corba.ee.spi.legacy.interceptor.IORInfoExt)iorInfo).
                                                                    getServerPort("SSL_MUTUALAUTH");
            } catch (com.sun.corba.ee.spi.legacy.interceptor.UnknownType ute) {
                _logger.log(Level.FINE,".isnert: UnknownType exception", ute);
            }

            if(_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, 
                            ".insert: sslMutualAuthPort: " 
                            + sslMutualAuthPort);
            }

            CSIV2TaggedComponentInfo ctc = new CSIV2TaggedComponentInfo(orb);
            ctc.setSSLMutualAuthPort(sslMutualAuthPort);
            result = ctc.createSecurityTaggedComponent(socketInfos);  
            return result;
	} finally {
	    if (_logger.isLoggable(Level.FINE)) {
		_logger.log(Level.FINE, baseMsg + ".insert<-: " + result);
	    }
	}
    }

    public List<SocketInfo> extract(IOR ior)
    {
	List<SocketInfo> socketInfo = null;
        try {
	    if (_logger.isLoggable(Level.FINE)) {
		_logger.log(Level.FINE, baseMsg + ".extract->:");
	    }
            SecurityMechanismSelector selector = new SecurityMechanismSelector();
            IIOPProfileTemplate iiopProfileTemplate = (IIOPProfileTemplate)ior.
                                 getProfile().getTaggedProfileTemplate();
            IIOPAddress primary = iiopProfileTemplate.getPrimaryAddress() ;
            String host = primary.getHost().toLowerCase();

            ConnectionContext ctx = new ConnectionContext();
            socketInfo = selector.getSSLPorts(ior, ctx);
            selector.setClientConnectionContext(ctx);
            if (socketInfo == null) {
                if (_logger.isLoggable(Level.FINE)) {
		    _logger.log(Level.FINE, baseMsg
				+ ".extract: did not find SSL SocketInfo");
		}
            } else {
                if (_logger.isLoggable(Level.FINE)) {
		    _logger.log(Level.FINE, baseMsg
				+ ".extract: found SSL socketInfo");
		}
            }        
	    if (_logger.isLoggable(Level.FINE)) {
		_logger.log(Level.FINE, baseMsg 
			    + ".extract: Connection Context:" + ctx);		
	    }
        } catch ( Exception ex ) {
	    _logger.log(Level.WARNING, "Exception getting SocketInfo", ex);
        } finally {
	    if (_logger.isLoggable(Level.FINE)) {
		_logger.log(Level.FINE, baseMsg + ".extract<-: " + socketInfo);
	    }
	}
	return socketInfo;
    }

    ////////////////////////////////////////////////////
    //
    // ORBConfigurator
    //

    public void configure(DataCollector collector, ORB orb) 
    {
	if (_logger.isLoggable(Level.FINE)) {
	    _logger.log(Level.FINE, ".configure->:");
	}

	this.orb = orb;
	try {
	    orb.register_initial_reference(
	        ORBConstants.CSI_V2_SSL_TAGGED_COMPONENT_HANDLER,
	        this);
	} catch (InvalidName e) {
	    _logger.log(Level.WARNING, ".configure: ", e);
	}

	if (_logger.isLoggable(Level.FINE)) {
	    _logger.log(Level.FINE, ".configure<-:");
	}
    }
}

// End of file.


