/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.report.html;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

/*
 * Basic implementation of a document.
 */
public class HTMLDocument implements Document {
    
    /**
     * The root HTML element.
     */
    private Element html = new HTMLElement(HTMLReportConstants.HTML);
    
    
    /**
     * The head element.
     */
    private Element head = html.addElement(HTMLReportConstants.HEAD);
    
    
    /**
     * The body element.
     */
    private Element body = html.addElement(HTMLReportConstants.BODY);
    
    
    /**
     * The doctype.
     */
    private String doctype = "-//W3C//DTD HTML 4.01 Transitional//EN";
  
    /**
     */
    public Element getBody() {
        return body;
    }


    /**
     */
    public Element getHead() {
        return head;
    }


    /**
     */
    public String getDoctype() {
        return doctype;
    }


    /**
     */
    public void setDoctype(String raw) {
        if (raw == null) {
            throw new NullPointerException("Doctype string is null.");
        }
        doctype = raw;
    }
    

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<!DOCTYPE html PUBLIC \"")
        	.append(Escape.getInstance().encodeEntities(doctype, ""))
        	.append("\">\n")
        	.append(html.toString());
        return buf.toString();
    }


    /**
     */
    public void write(Writer output) throws IOException {
        output.append("<!DOCTYPE html PUBLIC \"")
    		.append(Escape.getInstance().encodeEntities(doctype, ""))
    		.append("\">\n")
    		.append(html.toString());
        output.flush();
    }


    /**
     */
    public void write(File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        write(fw);
        fw.close();
    }


    /**
     */
    public void set(Element head, Element body) {
        if (head == null) {
            throw new NullPointerException("Head element is null.");
        }
        if (body == null) {
            throw new NullPointerException("Body element is null.");
        }
        
        // Check the element names.
        if (!head.getName().equalsIgnoreCase(HTMLReportConstants.HEAD)) {
            new HTMLElement("HEAD").add(head);
        }
        if (!body.getName().equalsIgnoreCase(HTMLReportConstants.BODY)) {
            new HTMLElement("BODY").add(head);
        }
        
        // Discard old elements.
        List<Element> elements = html.getElements("BODY");
        for (Element element : elements) {
            html.delete(element);
        } // Loop discarding body elements.
        elements = html.getElements("HEAD");
        for (Element element : elements) {
            html.delete(element);
        } // Loop discarding head elements.
        
        // Add the new elements.
        html.add(head);
        html.add(body);
        this.head = head;
        this.body = body;
    }


  
}
