/*
 * The contents of this file are subject to the terms 
 * of the Common Development and Distribution License 
 * (the License).  You may not use this file except in
 * compliance with the License.
 * 
 * You can obtain a copy of the license at 
 * https://glassfish.dev.java.net/public/CDDLv1.0.html or
 * glassfish/bootstrap/legal/CDDLv1.0.txt.
 * See the License for the specific language governing 
 * permissions and limitations under the License.
 * 
 * When distributing Covered Code, include this CDDL 
 * Header Notice in each file and include the License file 
 * at glassfish/bootstrap/legal/CDDLv1.0.txt.  
 * If applicable, add the following below the CDDL Header, 
 * with the fields enclosed by brackets [] replaced by
 * you own identifying information: 
 * "Portions Copyrighted [year] [name of copyright owner]"
 * 
 * Copyright 2006 Sun Microsystems, Inc. All rights reserved.
 */
package com.sun.enterprise.diagnostics.report.html;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;


/**
 * Provide a basic implementation of an attribute.
 */
public class HTMLAttribute implements Attribute, Text {
    
    /**
     * The name of this attribute.
     */
    private String name = null;
    
    /**
     * The value of this attribute.
     */
    private String value = null;

    private static final String DOUBLE_QUOTES ="\"";
    
    private static final char EQUALS = '=';
    /**
     * Create a new attribute.
     * @param name	The name of the attribute.
     * @param value	The value of the attribute.
     */
    public HTMLAttribute(String name, String value) {
        setName(name);
        setValue(value);
    }
    
    /**
     *
     */
    public String getName() {
        return name;
    }

    /**
     *
     */
    public void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Attribute name is null");
        }
        this.name = name;
    }


    /**
     *
     */
    public String getValue() {
        return value;
    }


    /**
     *
     */
    public void setValue(String value) {
        if (value == null) {
            throw new NullPointerException("Attribute value is null.");
        }
        this.value = value;
    }
    

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        String nameStr = Escape.getInstance().encodeEntities(name, " \t\r\n");
        String valueStr = Escape.getInstance().encodeEntities(value, "");
        StringBuffer buf = new StringBuffer();
        buf.append(nameStr)
        	.append(EQUALS+DOUBLE_QUOTES)
        	.append(valueStr)
        	.append(DOUBLE_QUOTES);
        return buf.toString();
    }


    /**
     */
    public void write(Writer output) throws IOException {
        output.append(toString());
        output.flush();
    }


    /**
     */
    public void write(File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        write(fw);
        fw.close();
    }

   
}
